/*
 * Decompiled with CFR 0.152.
 */
package it.ohalee.minecraftgpt;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import it.ohalee.minecraftgpt.OpenAI;
import it.ohalee.minecraftgpt.Type;
import it.ohalee.minecraftgpt.command.ChatCommand;
import it.ohalee.minecraftgpt.handler.ChatHandler;
import it.ohalee.minecraftgpt.handler.PlayerHandler;
import it.ohalee.minecraftgpt.util.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Cache<Player, StringBuilder> CACHE;
    public static Cache<Player, Type> USER_TYPE;

    public void onEnable() {
        this.saveDefaultConfig();
        OpenAI.init(this.getConfig().getString("API_KEY")).exceptionallyAsync(throwable -> {
            this.getLogger().severe("Error while initializing OpenAI service! Is your API key valid?");
            throwable.printStackTrace();
            return null;
        });
        CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).removalListener(notification -> {
            if (notification.getKey() == null) {
                return;
            }
            USER_TYPE.invalidate(notification.getKey());
            if (notification.getCause() == RemovalCause.EXPIRED) {
                ((Player)notification.getKey()).sendMessage(Messages.format(this.getConfig().getString("command.toggle.disabled")));
            }
        }).build();
        String priority = this.getConfig().getString("chat-priority", "HIGH").toUpperCase();
        Class<AsyncPlayerChatEvent> eventClass = AsyncPlayerChatEvent.class;
        this.getServer().getPluginManager().registerEvent(eventClass, (Listener)new ChatHandler(this), EventPriority.valueOf((String)priority), (listener, event) -> {
            try {
                listener.getClass().getMethod("onAsyncPlayerChat", eventClass).invoke((Object)listener, event);
            }
            catch (InvocationTargetException ex) {
                throw new EventException(ex.getCause());
            }
            catch (Throwable t) {
                throw new EventException(t);
            }
        }, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerHandler(this), (Plugin)this);
        ChatCommand command = new ChatCommand(this);
        PluginCommand chatgpt = this.getCommand("chatgpt");
        chatgpt.setExecutor((CommandExecutor)command);
        chatgpt.setTabCompleter((TabCompleter)command);
        this.getLogger().info("Plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("Plugin disabled!");
    }

    static {
        USER_TYPE = CacheBuilder.newBuilder().build();
    }
}

