/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatArray<T>
extends Flowable<T> {
    final Publisher<? extends T>[] sources;
    final boolean delayError;

    public FlowableConcatArray(Publisher<? extends T>[] sources, boolean delayError) {
        this.sources = sources;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(this.sources, this.delayError, s);
        s.onSubscribe(parent);
        parent.onComplete();
    }

    static final class ConcatArraySubscriber<T>
    extends SubscriptionArbiter
    implements Subscriber<T> {
        private static final long serialVersionUID = -8158322871608889516L;
        final Subscriber<? super T> actual;
        final Publisher<? extends T>[] sources;
        final boolean delayError;
        final AtomicInteger wip;
        int index;
        List<Throwable> errors;
        long produced;

        ConcatArraySubscriber(Publisher<? extends T>[] sources, boolean delayError, Subscriber<? super T> actual) {
            this.actual = actual;
            this.sources = sources;
            this.delayError = delayError;
            this.wip = new AtomicInteger();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.setSubscription(s);
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.delayError) {
                List<Throwable> list = this.errors;
                if (list == null) {
                    this.errors = list = new ArrayList<Throwable>(this.sources.length - this.index + 1);
                }
                list.add(t);
                this.onComplete();
            } else {
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            block10: {
                if (this.wip.getAndIncrement() != 0) break block10;
                Publisher<? extends T>[] sources = this.sources;
                int n = sources.length;
                int i = this.index;
                while (true) {
                    if (i == n) {
                        List<Throwable> list = this.errors;
                        if (list != null) {
                            if (list.size() == 1) {
                                this.actual.onError(list.get(0));
                            } else {
                                this.actual.onError(new CompositeException(list));
                            }
                        } else {
                            this.actual.onComplete();
                        }
                        return;
                    }
                    Publisher<T> p = sources[i];
                    if (p == null) {
                        NullPointerException ex = new NullPointerException("A Publisher entry is null");
                        if (this.delayError) {
                            List<Throwable> list = this.errors;
                            if (list == null) {
                                this.errors = list = new ArrayList<Throwable>(n - i + 1);
                            }
                            list.add(ex);
                            ++i;
                            continue;
                        }
                        this.actual.onError(ex);
                        return;
                    }
                    long r = this.produced;
                    if (r != 0L) {
                        this.produced = 0L;
                        this.produced(r);
                    }
                    p.subscribe(this);
                    this.index = ++i;
                    if (this.wip.decrementAndGet() == 0) break;
                }
            }
        }
    }
}

