/*
 * Decompiled with CFR 0.152.
 */
package me.serbob.toastedemojis.ToastedEmojisCommands;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.serbob.toastedemojis.ToastedEmojis;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;

public class ToastedEmojiReloadCommand
implements CommandExecutor {
    private final ToastedEmojis plugin;

    public ToastedEmojiReloadCommand(ToastedEmojis plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("toastedemojis")) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("toastedemojis.reload")) {
                    HashMap<String, Map<String, String>> unnormalEmojis;
                    String value;
                    HashMap<String, String> emojiMap;
                    ConfigurationSection categorySection;
                    HashMap<String, Map<String, String>> normalEmojis;
                    this.plugin.reloadConfig();
                    try {
                        this.plugin.getConfig().load(this.plugin.getConfigFile());
                    }
                    catch (IOException | InvalidConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    ConfigurationSection normalEmojisSection = this.plugin.getConfig().getConfigurationSection("normal-emojis");
                    ConfigurationSection unnormalEmojisSection = this.plugin.getConfig().getConfigurationSection("unnormal-emojis");
                    this.plugin.setConfig(this.plugin.getConfig());
                    this.plugin.setNormalEmojisSection(normalEmojisSection);
                    this.plugin.setUnnormalEmojisSection(unnormalEmojisSection);
                    if (normalEmojisSection != null) {
                        normalEmojis = new HashMap<String, Map<String, String>>();
                        for (String category : normalEmojisSection.getKeys(false)) {
                            categorySection = normalEmojisSection.getConfigurationSection(category);
                            if (categorySection == null) continue;
                            emojiMap = new HashMap<String, String>();
                            for (String emoji : categorySection.getKeys(false)) {
                                value = categorySection.getString(emoji);
                                emojiMap.put(emoji, value);
                            }
                            normalEmojis.put(category, emojiMap);
                        }
                        this.plugin.setNormalEmojis(normalEmojis);
                    } else {
                        normalEmojis = new HashMap();
                        this.plugin.setNormalEmojis(normalEmojis);
                    }
                    if (unnormalEmojisSection != null) {
                        unnormalEmojis = new HashMap<String, Map<String, String>>();
                        for (String category : unnormalEmojisSection.getKeys(false)) {
                            categorySection = unnormalEmojisSection.getConfigurationSection(category);
                            if (categorySection == null) continue;
                            emojiMap = new HashMap();
                            for (String emoji : categorySection.getKeys(false)) {
                                value = categorySection.getString(emoji);
                                emojiMap.put(emoji, value);
                            }
                            unnormalEmojis.put(category, emojiMap);
                        }
                        this.plugin.setUnnormalEmojis(unnormalEmojis);
                    } else {
                        unnormalEmojis = new HashMap();
                        this.plugin.setUnnormalEmojis(unnormalEmojis);
                    }
                    sender.sendMessage(ChatColor.GREEN + "ToastedEmojis config reloaded!");
                } else {
                    sender.sendMessage(ChatColor.RED + "You do not have permission to use this command.");
                }
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("list")) {
                if (sender.hasPermission("toastedemojis.list")) {
                    String symbol;
                    String emoji;
                    Map<String, String> emojiMap;
                    String category;
                    sender.sendMessage(ChatColor.GOLD + "Current Emojis:");
                    Map<String, Map<String, String>> normalEmojis = this.plugin.getNormalEmojis();
                    Map<String, Map<String, String>> unnormalEmojis = this.plugin.getUnnormalEmojis();
                    if (!normalEmojis.isEmpty()) {
                        for (Map.Entry<String, Map<String, String>> categoryEntry : normalEmojis.entrySet()) {
                            category = categoryEntry.getKey();
                            emojiMap = categoryEntry.getValue();
                            for (Map.Entry<String, String> emojiEntry : emojiMap.entrySet()) {
                                emoji = emojiEntry.getKey();
                                symbol = ChatColor.translateAlternateColorCodes((char)'&', (String)emojiEntry.getValue());
                                sender.sendMessage(ChatColor.GOLD + " - " + ChatColor.WHITE + category + ChatColor.GOLD + " -> " + ChatColor.WHITE + emoji + ChatColor.GOLD + " -> " + ChatColor.WHITE + symbol);
                            }
                        }
                    }
                    if (!unnormalEmojis.isEmpty()) {
                        for (Map.Entry<String, Map<String, String>> categoryEntry : unnormalEmojis.entrySet()) {
                            category = categoryEntry.getKey();
                            emojiMap = categoryEntry.getValue();
                            for (Map.Entry<String, String> emojiEntry : emojiMap.entrySet()) {
                                emoji = emojiEntry.getKey();
                                symbol = ChatColor.translateAlternateColorCodes((char)'&', (String)emojiEntry.getValue());
                                sender.sendMessage(ChatColor.GOLD + " - " + ChatColor.WHITE + category + ChatColor.GOLD + " -> " + ChatColor.WHITE + ":" + emoji + ":" + ChatColor.GOLD + " -> " + ChatColor.WHITE + symbol);
                            }
                        }
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "You do not have permission to use this command.");
                }
            }
        }
        return false;
    }
}

