/*
 * Decompiled with CFR 0.152.
 */
package me.serbob.toastedemojis;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.serbob.toastedemojis.ToastedEmojisCommands.ToastedEmojiReloadCommand;
import me.serbob.toastedemojis.ToastedEmojisCommands.ToastedEmojiReloadTabCompleter;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ToastedEmojis
extends JavaPlugin
implements Listener {
    private File configFile;
    private YamlConfiguration config;
    private ConfigurationSection normalEmojisSection;
    private ConfigurationSection unnormalEmojisSection;
    private Map<String, Map<String, String>> normalEmojis = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> unnormalEmojis = new HashMap<String, Map<String, String>>();

    public void onEnable() {
        String value;
        HashMap<String, String> emojiMap;
        ConfigurationSection categorySection;
        String permissionName;
        this.saveDefaultConfig();
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.normalEmojisSection = this.config.getConfigurationSection("normal-emojis");
        this.unnormalEmojisSection = this.config.getConfigurationSection("unnormal-emojis");
        if (this.normalEmojisSection != null) {
            for (String category : this.normalEmojisSection.getKeys(false)) {
                permissionName = "toastedemojis.emoji." + category;
                if (this.getServer().getPluginManager().getPermission(permissionName) == null) {
                    this.getServer().getPluginManager().addPermission(new Permission(permissionName));
                }
                if ((categorySection = this.normalEmojisSection.getConfigurationSection(category)) == null) continue;
                emojiMap = new HashMap<String, String>();
                for (String emoji : categorySection.getKeys(false)) {
                    value = categorySection.getString(emoji);
                    emojiMap.put(emoji, value);
                }
                this.normalEmojis.put(category, emojiMap);
            }
        } else {
            this.getLogger().warning("The 'normal-emojis' section is missing or empty in the config.yml file.");
            this.config.set("replace_color", (Object)false);
            this.config.createSection("normal-emojis");
            this.config.set("normal-emojis.default.o/", (Object)"&dhi&r");
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to save the updated config.yml file.");
                e.printStackTrace();
            }
        }
        if (this.unnormalEmojisSection != null) {
            for (String category : this.unnormalEmojisSection.getKeys(false)) {
                permissionName = "toastedemojis.emoji." + category;
                if (this.getServer().getPluginManager().getPermission(permissionName) == null) {
                    this.getServer().getPluginManager().addPermission(new Permission(permissionName));
                }
                if ((categorySection = this.unnormalEmojisSection.getConfigurationSection(category)) == null) continue;
                emojiMap = new HashMap();
                for (String emoji : categorySection.getKeys(false)) {
                    value = categorySection.getString(emoji);
                    emojiMap.put(emoji, value);
                }
                this.unnormalEmojis.put(category, emojiMap);
            }
        } else {
            this.getLogger().warning("The 'unnormal-emojis' section is missing or empty in the config.yml file. Default values will be used.");
            this.config.set("replace_color", (Object)false);
            this.config.createSection("unnormal-emojis");
            this.config.set("unnormal-emojis.default.lenny", (Object)"&3( \u0361\u00b0 \u035c\u0296&5 \u0361\u00b0)");
            this.config.set("unnormal-emojis.default.shrug", (Object)"\u00af\\_(\u30c4)_/\u00af");
            this.config.createSection("unnormal-emojis.mvp");
            this.config.set("unnormal-emojis.mvp.tableflip", (Object)"(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b");
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to save the updated config.yml file.");
                e.printStackTrace();
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("toastedemojis").setExecutor((CommandExecutor)new ToastedEmojiReloadCommand(this));
        this.getCommand("toastedemojis").setTabCompleter((TabCompleter)new ToastedEmojiReloadTabCompleter());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String symbol;
        String value;
        String emoji;
        Map<String, String> emojiMap;
        String permissionName;
        String category;
        String originalMessage;
        Player player = event.getPlayer();
        String replacedMessage = originalMessage = event.getMessage();
        for (Map.Entry<String, Map<String, String>> entry : this.normalEmojis.entrySet()) {
            category = entry.getKey();
            permissionName = "toastedemojis.emoji." + category;
            if (!player.hasPermission(permissionName)) continue;
            emojiMap = entry.getValue();
            for (Map.Entry<String, String> emojiEntry : emojiMap.entrySet()) {
                emoji = emojiEntry.getKey();
                value = emojiEntry.getValue();
                symbol = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
                if (this.getConfig().getBoolean("replace_color")) {
                    replacedMessage = replacedMessage.replace(emoji, symbol);
                    continue;
                }
                replacedMessage = replacedMessage.replace(emoji, value);
            }
        }
        for (Map.Entry<String, Map<String, String>> entry : this.unnormalEmojis.entrySet()) {
            category = entry.getKey();
            permissionName = "toastedemojis.emoji." + category;
            if (!player.hasPermission(permissionName)) continue;
            emojiMap = entry.getValue();
            for (Map.Entry<String, String> emojiEntry : emojiMap.entrySet()) {
                emoji = emojiEntry.getKey();
                value = emojiEntry.getValue();
                symbol = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
                String pattern = ":" + emoji + ":";
                if (this.getConfig().getBoolean("replace_color")) {
                    replacedMessage = replacedMessage.replace(pattern, symbol);
                    continue;
                }
                replacedMessage = replacedMessage.replace(pattern, value);
            }
        }
        event.setMessage(replacedMessage);
    }

    public void onDisable() {
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(YamlConfiguration config) {
        this.config = config;
    }

    public ConfigurationSection getNormalEmojisSection() {
        return this.normalEmojisSection;
    }

    public void setNormalEmojisSection(ConfigurationSection normalEmojisSection) {
        this.normalEmojisSection = normalEmojisSection;
    }

    public ConfigurationSection getUnnormalEmojisSection() {
        return this.unnormalEmojisSection;
    }

    public void setUnnormalEmojisSection(ConfigurationSection unnormalEmojisSection) {
        this.unnormalEmojisSection = unnormalEmojisSection;
    }

    public Map<String, Map<String, String>> getNormalEmojis() {
        return this.normalEmojis;
    }

    public void setNormalEmojis(Map<String, Map<String, String>> normalEmojis) {
        this.normalEmojis = normalEmojis;
    }

    public Map<String, Map<String, String>> getUnnormalEmojis() {
        return this.unnormalEmojis;
    }

    public void setUnnormalEmojis(Map<String, Map<String, String>> unnormalEmojis) {
        this.unnormalEmojis = unnormalEmojis;
    }
}

