/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities.ubb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.ubb.BlockChangeManager;
import me.ultra42.ultraskills.utilities.ubb.UltraBlockBreakEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UltraBlock {
    public static boolean breakBlock(Block b, Player p, ItemStack tool) {
        if (b == null) {
            return false;
        }
        if (b.getType().equals((Object)Material.AIR) || b.getType().equals((Object)Material.CAVE_AIR) || b.getType().equals((Object)Material.VOID_AIR)) {
            return false;
        }
        float breakSpeed = b.getBreakSpeed(p);
        if (breakSpeed <= 0.0f) {
            return false;
        }
        ItemStack item = p.getInventory().getItemInMainHand();
        DebugUtility.consoleMessage(p.getName() + " mined " + b.getType() + " (" + b.getLocation() + ") with a " + item.getType().name(), 4);
        p.playSound(b.getLocation(), b.getBlockSoundGroup().getBreakSound(), 1.0f, 1.0f);
        UltraBlock.giveXP(p, b);
        Bukkit.getServer().getPluginManager().callEvent((Event)new UltraBlockBreakEvent(b, p, item));
        p.getWorld().playSound(b.getLocation(), b.getBlockSoundGroup().getBreakSound(), 1.0f, 1.0f);
        if (tool instanceof Damageable) {
            Damageable damageable = (Damageable)tool;
            int unbreakingLevel = tool.getEnchantmentLevel(Enchantment.DURABILITY);
            double chance = 1.0 / (double)(unbreakingLevel + 1);
            if (Math.random() < chance) {
                damageable.setDamage(damageable.getDamage() + 1);
            }
        }
        b.setType(Material.AIR);
        BlockChangeManager.setMaker(b, p);
        return true;
    }

    public static void breakBlocks(ArrayList<ArrayList<Block>> blocks, final Player p) {
        final ItemStack tool = p.getInventory().getItemInMainHand();
        int phase = 0;
        for (ArrayList<Block> layer : blocks) {
            ++phase;
            for (final Block b : layer) {
                Damageable d;
                if (tool instanceof Damageable && (d = (Damageable)tool).getDamage() >= tool.getType().getMaxDurability()) continue;
                try {
                    float breakSpeed = UltraBlock.getBreakTime(b, p);
                    DebugUtility.consoleMessage("Break speed of " + p.getName() + "'s " + tool.getType() + ": " + breakSpeed, 4);
                    new BukkitRunnable(){

                        public void run() {
                            UltraBlock.breakBlock(b, p, tool);
                        }
                    }.runTaskLater((Plugin)UltraSkills.getPlugin(), (long)(1.0f / breakSpeed * (float)phase));
                }
                catch (UnsupportedOperationException ex) {
                    DebugUtility.consoleMessage(b.getType() + " cannot be broken by " + p.getName(), 4);
                }
            }
        }
    }

    private static float getBreakTime(Block b, Player p) {
        return b.getBreakSpeed(p);
    }

    public static void giveXP(Player p, Block b) {
    }

    public static ArrayList<ArrayList<Block>> findContiguousBlocks(Block source) {
        ArrayList<ArrayList<Block>> result = new ArrayList<ArrayList<Block>>();
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        Material sourceMaterial = source.getType();
        queue.add(source);
        visited.add(source);
        while (!queue.isEmpty()) {
            Block current;
            int levelSize = queue.size();
            ArrayList<Block> level = new ArrayList<Block>();
            for (int i = 0; i < levelSize && (current = (Block)queue.poll()) != null; ++i) {
                for (BlockFace face : BlockFace.values()) {
                    Block neighbor = current.getRelative(face);
                    if (visited.contains(neighbor) || neighbor.getType() != sourceMaterial) continue;
                    queue.add(neighbor);
                    visited.add(neighbor);
                    level.add(neighbor);
                }
            }
            if (level.isEmpty()) continue;
            result.add(level);
        }
        return result;
    }

    public static ArrayList<ArrayList<Block>> findContiguousBlocks(Block source, boolean diagonalNeighbors, int maxBlocks) {
        ArrayList<ArrayList<Block>> result = new ArrayList<ArrayList<Block>>();
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        Material sourceMaterial = source.getType();
        queue.add(source);
        visited.add(source);
        int blockCount = 0;
        while (!queue.isEmpty() && blockCount < maxBlocks) {
            int levelSize = queue.size();
            ArrayList<Block> level = new ArrayList<Block>();
            block1: for (int i = 0; i < levelSize && blockCount < maxBlocks; ++i) {
                Block current = (Block)queue.poll();
                for (Block neighbor : UltraBlock.getNeighborsIncludingDiagonal(current)) {
                    if (visited.contains(neighbor) || neighbor.getType() != sourceMaterial) continue;
                    queue.add(neighbor);
                    visited.add(neighbor);
                    level.add(neighbor);
                    if (++blockCount < maxBlocks) continue;
                    continue block1;
                }
            }
            if (level.isEmpty()) continue;
            result.add(level);
        }
        return result;
    }

    private static List<Block> getNeighborsIncludingDiagonal(Block block) {
        ArrayList<Block> neighbors = new ArrayList<Block>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    neighbors.add(block.getRelative(x, y, z));
                }
            }
        }
        return neighbors;
    }

    public record BlockWithDistance(Block block, int distance) {
    }
}

