/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities.ubb;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockChangeManager
implements Listener {
    public static Set<Material> pillar_crops = EnumSet.of(Material.SUGAR_CANE, Material.KELP_PLANT, Material.BAMBOO, Material.BAMBOO_SAPLING, Material.CACTUS);
    public static Set<Material> stem_crops = EnumSet.of(Material.MELON, Material.PUMPKIN);
    public static Set<Material> stems = EnumSet.of(Material.ATTACHED_MELON_STEM, Material.ATTACHED_PUMPKIN_STEM, Material.MELON_STEM, Material.PUMPKIN_STEM);
    public static Set<Material> spread_up_crops = EnumSet.of(Material.BAMBOO, Material.KELP, Material.KELP_PLANT);
    public static Set<Material> spread_down_crops = EnumSet.of(Material.VINE, Material.WEEPING_VINES, Material.TWISTING_VINES);

    @EventHandler
    public void breakBlockEvent(BlockBreakEvent e) {
        String player_name = e.getPlayer().getName();
        Block b = e.getBlock();
        Location loc = b.getLocation();
        String block_name = loc.getBlockX() + "/" + loc.getBlockY() + "/" + loc.getBlockZ();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), block_name);
        if (BlockChangeManager.isManMade(loc, b.getWorld())) {
            String string = (String)e.getBlock().getChunk().getPersistentDataContainer().get(key, PersistentDataType.STRING);
        }
    }

    @EventHandler
    public void placeBlockEvent(BlockPlaceEvent e) {
        String player_name = e.getPlayer().getName();
        Block b = e.getBlock();
        Location loc = b.getLocation();
        String block_name = loc.getBlockX() + "/" + loc.getBlockY() + "/" + loc.getBlockZ();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), block_name);
        e.getBlock().getChunk().getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)player_name);
    }

    @EventHandler
    public void blockGrow(BlockGrowEvent e) {
        Block b = e.getBlock();
        Block below = b.getWorld().getBlockAt(b.getLocation().add(0.0, -1.0, 0.0));
        if (BlockChangeManager.isManMade(b)) {
            Player player = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(b));
        } else if (pillar_crops.contains(below.getType()) && BlockChangeManager.isManMade(below)) {
            Player m = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(below));
            BlockChangeManager.setMaker(b, m);
        } else if (stem_crops.contains(e.getNewState().getType())) {
            Block north = b.getWorld().getBlockAt(b.getLocation().add(0.0, 0.0, 1.0));
            Block south = b.getWorld().getBlockAt(b.getLocation().add(0.0, 0.0, -1.0));
            Block east = b.getWorld().getBlockAt(b.getLocation().add(-1.0, 0.0, 0.0));
            Block west = b.getWorld().getBlockAt(b.getLocation().add(1.0, 0.0, 0.0));
            if (stems.contains(north.getType()) && BlockChangeManager.isManMade(north)) {
                Player m = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(north));
                BlockChangeManager.setMaker(b, m);
            } else if (stems.contains(south.getType()) && BlockChangeManager.isManMade(south)) {
                Player m = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(south));
                BlockChangeManager.setMaker(b, m);
            } else if (stems.contains(east.getType()) && BlockChangeManager.isManMade(east)) {
                Player m = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(east));
                BlockChangeManager.setMaker(b, m);
            } else if (stems.contains(west.getType()) && BlockChangeManager.isManMade(west)) {
                Player m = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(west));
                BlockChangeManager.setMaker(b, m);
            }
        }
    }

    @EventHandler
    public void blockSpread(BlockSpreadEvent e) {
        Block b = e.getBlock();
        Material m = e.getNewState().getType();
        Block above = b.getWorld().getBlockAt(b.getLocation().add(0.0, 1.0, 0.0));
        Block below = b.getWorld().getBlockAt(b.getLocation().add(0.0, -1.0, 0.0));
        if (spread_up_crops.contains(m) && BlockChangeManager.isManMade(below)) {
            Player p = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(below));
            BlockChangeManager.setMaker(b, p);
        } else if (spread_down_crops.contains(m) && BlockChangeManager.isManMade(above)) {
            Player p = Bukkit.getServer().getPlayer(BlockChangeManager.getMaker(above));
            BlockChangeManager.setMaker(b, p);
        }
    }

    public static boolean isManMade(Location loc, World world) {
        String breaker;
        Block b = world.getBlockAt(loc);
        if (b.getType() == Material.AIR) {
            return false;
        }
        String block_name = loc.getBlockX() + "/" + loc.getBlockY() + "/" + loc.getBlockZ();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), block_name);
        return b.getChunk().getPersistentDataContainer().has(key, PersistentDataType.STRING) && (breaker = (String)b.getChunk().getPersistentDataContainer().get(key, PersistentDataType.STRING)) != "";
    }

    public static boolean isManMade(Block b) {
        return BlockChangeManager.isManMade(b.getLocation(), b.getWorld());
    }

    public static String getMaker(Block b) {
        String breaker;
        String block_name = b.getLocation().getBlockX() + "/" + b.getLocation().getBlockY() + "/" + b.getLocation().getBlockZ();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), block_name);
        if (b.getChunk().getPersistentDataContainer().has(key, PersistentDataType.STRING) && !Objects.equals(breaker = (String)b.getChunk().getPersistentDataContainer().get(key, PersistentDataType.STRING), "")) {
            return breaker;
        }
        return null;
    }

    public static void setMaker(Block b, Player p) {
        String block_name = b.getLocation().getBlockX() + "/" + b.getLocation().getBlockY() + "/" + b.getLocation().getBlockZ();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), block_name);
        String breaker = p.getName();
        b.getChunk().getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)breaker);
    }
}

