/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class WikiMaker {
    public static int generateSkillsTable(String packageName) {
        String settingString = UltraSkills.getPlugin().getConfig().getString("test.generate-skill-table");
        boolean settingBoolean = false;
        try {
            settingBoolean = Boolean.parseBoolean(settingString);
        }
        catch (NumberFormatException e) {
            DebugUtility.consoleMessage("Debug level invalid: [" + settingString + "] Default is 1.");
        }
        if (!settingBoolean) {
            return 0;
        }
        DebugUtility.consoleMessage("[Wiki] Generating skills.html...", 1);
        int count = 0;
        try (FileWriter fw = new FileWriter("plugins\\UltraSkills\\skills.html");
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write("<html><body><script src=\"https://www.kryogenix.org/code/browser/sorttable/sorttable.js\"></script><table class=\"sortable\" border ='1'><tr><td>Tree</td><td>Skill Name</td><td>Level</td><td>Description</td></tr>");
            for (Class<Talent> clazz : new Reflections(packageName + ".abilities", new Scanner[0]).getSubTypesOf(Talent.class)) {
                try {
                    DebugUtility.consoleMessage("[Wiki] Labeling " + clazz.getName(), 5);
                    Talent t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    String color = SkillGroup.getSkillColor(t.getTree()).asHexString();
                    bw.write(" <tr bgcolor=\"" + color + "\"><td>");
                    bw.write(t.getTree());
                    bw.write("</td><td>");
                    bw.write(t.getName());
                    bw.write("</td><td>");
                    bw.write("" + t.getLevelRequirement());
                    bw.write("</td><td>");
                    bw.write(t.getDescription());
                    ++count;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            bw.write("</table></body></html>");
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            DebugUtility.consoleMessage("Cannot export skill table. Error writing to file: " + e.getMessage());
        }
        return count;
    }
}

