/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import me.ultra42.ultraskills.UltraSkills;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class UpdateChecker
implements Listener {
    private String url = "https://api.spigotmc.org/legacy/update.php?resource=";
    private String id = "106902";
    private boolean isAvailable;

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @EventHandler
    public void on(PlayerJoinEvent event) {
        if (event.getPlayer().isOp()) {
            this.checkUpdate();
        }
        if (this.isAvailable) {
            TextComponent message = (TextComponent)Component.text((String)"A new version of UltraSkills is available!").color((TextColor)NamedTextColor.RED);
            message = (TextComponent)message.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.OPEN_URL, (String)"https://www.spigotmc.org/resources/ultraskills-rpg-progression-skill-system.106902/"));
            message = (TextComponent)message.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)Component.text((String)"https://www.spigotmc.org/resources/ultraskills-rpg-progression-skill-system.106902/")));
            event.getPlayer().sendMessage((Component)message);
        } else {
            event.getPlayer().sendMessage(Component.text((String)"Running the latest version of UltraSkills.").color((TextColor)NamedTextColor.GREEN));
        }
    }

    public void check() {
        this.isAvailable = this.checkUpdate();
    }

    private boolean checkUpdate() {
        UltraSkills.getPlugin().getLogger().info("Checking for updates...");
        try {
            String localVersion = UltraSkills.getPlugin().getDescription().getVersion();
            HttpsURLConnection connection = (HttpsURLConnection)new URL(this.url + this.id).openConnection();
            connection.setRequestMethod("GET");
            String raw = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            String remoteVersion = raw.contains("-") ? raw.split("-")[0].trim() : raw;
            String currentVersionText = "Current Version: " + localVersion;
            String latestVersionText = "Latest Version: " + remoteVersion;
            if (!localVersion.equalsIgnoreCase(remoteVersion)) {
                currentVersionText = ChatColor.RED + currentVersionText;
                latestVersionText = ChatColor.GREEN + latestVersionText;
            }
            Bukkit.getServer().getConsoleSender().sendMessage("[UltraSkills] " + currentVersionText);
            Bukkit.getServer().getConsoleSender().sendMessage("[UltraSkills] " + latestVersionText);
            if (!localVersion.equalsIgnoreCase(remoteVersion)) {
                Bukkit.getServer().getConsoleSender().sendMessage("[UltraSkills] " + ChatColor.GREEN + "There is a newer release available!");
                return true;
            }
        }
        catch (IOException e) {
            UltraSkills.getPlugin().getLogger().info("Could not connect to Spigot API.");
            return false;
        }
        UltraSkills.getPlugin().getLogger().info("Running the latest version of UltraSkills.");
        return false;
    }
}

