/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities;

import me.ultra42.ultraskills.UltraSkills;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PersistentDataUtility {
    public static boolean store(Player p, String key, String value) {
        boolean fresh = false;
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        if (!p.getPersistentDataContainer().has(k, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(k, PersistentDataType.STRING, (Object)"");
            fresh = true;
        }
        p.getPersistentDataContainer().set(k, PersistentDataType.STRING, (Object)value);
        return fresh;
    }

    public static String readString(Player p, String key) {
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        if (!p.getPersistentDataContainer().has(k, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(k, PersistentDataType.STRING, (Object)"");
        }
        String value = (String)p.getPersistentDataContainer().get(k, PersistentDataType.STRING);
        return value;
    }

    public static boolean store(Entity entity, String key, int value) {
        boolean fresh = false;
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        if (!entity.getPersistentDataContainer().has(k, PersistentDataType.INTEGER)) {
            entity.getPersistentDataContainer().set(k, PersistentDataType.INTEGER, (Object)0);
            fresh = true;
        }
        entity.getPersistentDataContainer().set(k, PersistentDataType.INTEGER, (Object)value);
        return fresh;
    }

    public static int readInt(Entity entity, String key) {
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        if (!entity.getPersistentDataContainer().has(k, PersistentDataType.INTEGER)) {
            entity.getPersistentDataContainer().set(k, PersistentDataType.INTEGER, (Object)0);
        }
        int value = (Integer)entity.getPersistentDataContainer().get(k, PersistentDataType.INTEGER);
        return value;
    }

    public static int readInt(Entity entity, String key, int def) {
        if (PersistentDataUtility.hasInt(entity, key)) {
            return PersistentDataUtility.readInt(entity, key);
        }
        return def;
    }

    public static boolean hasInt(Entity entity, String key) {
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        return entity.getPersistentDataContainer().has(k, PersistentDataType.INTEGER);
    }

    public static boolean store(Entity p, String key, String value) {
        boolean fresh = false;
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        if (!p.getPersistentDataContainer().has(k, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(k, PersistentDataType.STRING, (Object)"");
            fresh = true;
        }
        p.getPersistentDataContainer().set(k, PersistentDataType.STRING, (Object)value);
        return fresh;
    }

    public static String readString(Entity p, String key) {
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        if (!p.getPersistentDataContainer().has(k, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(k, PersistentDataType.STRING, (Object)"");
        }
        String value = (String)p.getPersistentDataContainer().get(k, PersistentDataType.STRING);
        return value;
    }

    public static String readString(Entity p, String key, String def) {
        if (PersistentDataUtility.hasString(p, key)) {
            return PersistentDataUtility.readString(p, key);
        }
        return def;
    }

    public static boolean hasString(Entity p, String key) {
        NamespacedKey k = new NamespacedKey((Plugin)UltraSkills.getPlugin(), key);
        return p.getPersistentDataContainer().has(k, PersistentDataType.STRING);
    }
}

