/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities;

import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class DebugUtility {
    public static final Set<String> DEVELOPERS = Set.of("42ultra", "Lab42899");

    public static void consoleMessage(String text) {
        String debugEnabled = UltraSkills.getPlugin().getConfig().getString("test.debug-messages");
        if (Boolean.parseBoolean(debugEnabled)) {
            UltraSkills.getPlugin().getLogger().info("[Debug] " + text);
        }
    }

    public static int getDebugLevel() {
        String debugLevelString = UltraSkills.getPlugin().getConfig().getString("test.debug-level");
        int debugLevel = 0;
        try {
            debugLevel = Integer.parseInt(debugLevelString);
        }
        catch (NumberFormatException e) {
            DebugUtility.consoleMessage("Debug level invalid: [" + debugLevelString + "] Default is 1.");
        }
        return debugLevel;
    }

    public static void consoleMessage(String text, int priority) {
        if (DebugUtility.getDebugLevel() >= priority) {
            DebugUtility.consoleMessage(text);
        }
    }

    public static void devMessage(String text, int priority) {
        if (DebugUtility.getDebugLevel() < priority) {
            return;
        }
        for (String playerName : DEVELOPERS) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null || !player.isOnline()) continue;
            player.sendMessage(text);
        }
    }
}

