/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.utilities;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import me.ultra42.ultraskills.UltraSkills;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class AbilityManager
implements Listener {
    private static HashMap<String, HashMap<String, Instant>> playerCooldowns = new HashMap();

    public static Instant getCooldown(Player p, String s) {
        HashMap<String, Instant> cds = playerCooldowns.get(p.getUniqueId().toString());
        return cds.get(s);
    }

    public static boolean isOffCooldown(Player p, String s) {
        HashMap<String, Instant> cds = playerCooldowns.get(p.getUniqueId().toString());
        return cds.get(s).isBefore(Instant.now());
    }

    public static void putCooldown(Player p, String s, int milliseconds) {
        HashMap<String, Instant> cds = playerCooldowns.get(p.getUniqueId().toString());
        cds.put(s, Instant.now().plusMillis(milliseconds));
    }

    public static void removeCooldown(Player p, String s) {
        if (playerCooldowns.get(p.getUniqueId().toString()).containsKey(s)) {
            playerCooldowns.get(p.getUniqueId().toString()).remove(s);
        }
    }

    public static void createPlayerCooldowns(Player p) {
        HashMap cds = new HashMap();
        playerCooldowns.put(p.getUniqueId().toString(), cds);
    }

    public static boolean hasAbility(Player p, String s) {
        if (p.getGameMode() != GameMode.SURVIVAL && p.getGameMode() != GameMode.ADVENTURE) {
            return false;
        }
        return playerCooldowns.get(p.getUniqueId().toString()).containsKey(s);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (!playerCooldowns.containsKey(e.getPlayer().getUniqueId().toString())) {
            AbilityManager.createPlayerCooldowns(e.getPlayer());
        }
        AbilityManager.restoreCooldowns(e.getPlayer());
        e.getPlayer().sendMessage(UltraSkills.welcomePlayer(e.getPlayer()));
    }

    public static void saveCooldowns() {
        for (Map.Entry<String, HashMap<String, Instant>> entry : playerCooldowns.entrySet()) {
            for (Map.Entry<String, Instant> entry2 : entry.getValue().entrySet()) {
                UltraSkills.getData().getConfig().set("players." + entry.getKey() + ".cooldowns." + entry2.getKey(), (Object)entry2.getValue().toString());
            }
        }
        UltraSkills.getData().saveConfig();
    }

    public static void restoreCooldowns(Player p) {
        UltraSkills.getPlugin().getLogger().info("Retrieving " + p.getName() + "'s cooldowns.");
        if (UltraSkills.getData().getConfig().contains("players." + p.getUniqueId() + ".cooldowns")) {
            AbilityManager.createPlayerCooldowns(p);
            HashMap cd_map = new HashMap();
            int[] count = new int[]{0};
            UltraSkills.getData().getConfig().getConfigurationSection("players." + p.getUniqueId() + ".cooldowns").getKeys(false).forEach(key -> {
                Instant cd_instant = Instant.parse(UltraSkills.getData().getConfig().get("players." + p.getUniqueId() + ".cooldowns." + key).toString());
                cd_map.put(String.valueOf(key), cd_instant);
                count[0] = count[0] + 1;
            });
            UltraSkills.getPlugin().getLogger().info("Added " + count[0] + " cooldown for " + p.getName());
            playerCooldowns.put(p.getUniqueId().toString(), cd_map);
        }
    }

    public static void restoreCooldowns() {
        for (Player p : UltraSkills.getPlugin().getServer().getOnlinePlayers()) {
            AbilityManager.restoreCooldowns(p);
        }
    }

    public static boolean close() {
        if (!playerCooldowns.isEmpty()) {
            AbilityManager.saveCooldowns();
            UltraSkills.getPlugin().getLogger().info("Skill cooldowns saved to file. Closed successfully!");
            return true;
        }
        UltraSkills.getPlugin().getLogger().info("No skill cooldowns to save. Closed successfully.");
        return false;
    }
}

