/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.tools;

import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.magic.Catalyst;
import me.ultra42.ultraskills.abilities.magic.Conjure;
import me.ultra42.ultraskills.abilities.magic.Fireball;
import me.ultra42.ultraskills.abilities.magic.IceCapades;
import me.ultra42.ultraskills.abilities.magic.Illuminate;
import me.ultra42.ultraskills.abilities.magic.InvisibleHand;
import me.ultra42.ultraskills.abilities.magic.LightningInABottle;
import me.ultra42.ultraskills.abilities.magic.Medic;
import me.ultra42.ultraskills.abilities.magic.Necromancy;
import me.ultra42.ultraskills.abilities.magic.Spy;
import me.ultra42.ultraskills.abilities.magic.WebCrawler;
import me.ultra42.ultraskills.tools.Tool;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class Wand
extends Tool {
    private static String name = "Wand";
    private static Material type = Material.STICK;
    static HashMap<String, String> spell_rotation = new HashMap();
    static List<String> spell_list = Arrays.asList("Catalyst", "Conjure", "Fireball", "IceCapades", "Illuminate", "InvisibleHand", "LightningInABottle", "Medic", "Necromancy", "Spy", "WebCrawler");

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Wand(), p);
        Wand.loadSpells();
    }

    public static boolean getType(Material m) {
        return m.equals((Object)type);
    }

    public static boolean isWand(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.getType().equals((Object)type);
    }

    @EventHandler
    private void onRightClickWand(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !e.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        if (!(Objects.equals(e.getHand(), EquipmentSlot.HAND) && Wand.isWand(e.getPlayer().getInventory().getItemInMainHand()) || Objects.equals(e.getHand(), EquipmentSlot.OFF_HAND) && Wand.isWand(e.getPlayer().getInventory().getItemInOffHand()))) {
            return;
        }
        if (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else if (e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "wand_mode");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)name);
        }
        String spell = (String)p.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        assert (spell != null);
        this.cast(e, spell, true);
    }

    public static void loadSpells() {
        for (int i = 0; i < spell_list.size(); ++i) {
            String str = spell_list.get(i);
            if (i == spell_list.size() - 1) {
                spell_rotation.put(spell_list.get(i), spell_list.get(0));
                continue;
            }
            spell_rotation.put(spell_list.get(i), spell_list.get(i + 1));
        }
    }

    public static void displayWandUI(Player p, String spell) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard board = manager.getNewScoreboard();
        Objective obj = board.registerNewObjective("WandScoreboard", Criteria.DUMMY, (Component)Component.text((String)"Spell Selected:"));
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        int count = 0;
        for (String s : spell_list) {
            if (!AbilityManager.hasAbility(p, s)) continue;
            Score score = s.equals(spell) ? obj.getScore(ChatColor.YELLOW + s) : obj.getScore(ChatColor.WHITE + s);
            score.setScore(count);
            ++count;
        }
        p.setScoreboard(board);
    }

    public static String rotateSpell(String spell) {
        return spell_rotation.get(spell);
    }

    public static String rotateSpell(Player p, String spell, boolean reverse) {
        int i = spell_list.indexOf(spell);
        spell = reverse && i == 0 ? spell_list.get(spell_list.size() - 1) : (reverse ? spell_list.get(i - 1) : (i == spell_list.size() - 1 ? spell_list.get(0) : spell_list.get(i + 1)));
        if (!AbilityManager.hasAbility(p, spell)) {
            return Wand.rotateSpell(p, spell, reverse);
        }
        return spell;
    }

    @EventHandler
    private void onLeftClickWand(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!AbilityManager.hasAbility(p, name) || !AbilityManager.isOffCooldown(p, name)) {
            return;
        }
        if (!e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR)) {
            return;
        }
        if (!(e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)type) || e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)type))) {
            return;
        }
        if (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else if (e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "wand_mode");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)name);
        }
        String spell = (String)p.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        this.cast(e, spell, false);
    }

    public void cast(PlayerInteractEvent e, String spell, boolean isSecondary) {
        switch (spell) {
            case "InvisibleHand": {
                InvisibleHand.cast(e, isSecondary);
                break;
            }
            case "Fireball": {
                Fireball.cast(e, isSecondary);
                break;
            }
            case "LightningInABottle": {
                LightningInABottle.cast(e, isSecondary);
                break;
            }
            case "Illuminate": {
                Illuminate.cast(e, isSecondary);
                break;
            }
            case "Spy": {
                Spy.cast(e, isSecondary);
                break;
            }
            case "Catalyst": {
                Catalyst.cast(e, isSecondary);
                break;
            }
            case "IceCapades": {
                IceCapades.cast(e, isSecondary);
                break;
            }
            case "Conjure": {
                Conjure.cast(e, isSecondary);
                break;
            }
            case "WebCrawler": {
                WebCrawler.cast(e, isSecondary);
                break;
            }
            case "Medic": {
                Medic.cast(e, isSecondary);
                break;
            }
            case "Necromancy": {
                Necromancy.cast(e, isSecondary);
            }
        }
    }

    @EventHandler
    public void onPlayerSwitchItem(PlayerSwapHandItemsEvent e) {
        final Player p = e.getPlayer();
        if (Wand.isWand(e.getMainHandItem()) || Wand.isWand(e.getOffHandItem())) {
            e.setCancelled(true);
            String spell = PersistentDataUtility.readString((Entity)p, "wand_mode", "InvisibleHand");
            if (spell.equals("")) {
                spell = "InvisibleHand";
            }
            spell = Wand.rotateSpell(p, spell, !p.isSneaking());
            Wand.displayWandUI(p, spell);
            AbilityManager.putCooldown(p, name, 500);
            PersistentDataUtility.store(p, "wand_mode", spell);
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.5f);
            DebugUtility.consoleMessage(p.getName() + " " + name + " switching wand to " + spell, 3);
            new BukkitRunnable(){

                public void run() {
                    Instant cd = AbilityManager.getCooldown(p, name).plusSeconds(5L);
                    if (cd != null && cd.isBefore(Instant.now())) {
                        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
                        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
                        p.setScoreboard(scoreboard);
                        this.cancel();
                    } else if (cd == null) {
                        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
                        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
                        p.setScoreboard(scoreboard);
                        this.cancel();
                    }
                    DebugUtility.consoleMessage(p.getName() + " " + name + " menu", 4);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 20L);
        }
    }
}

