/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.tools;

import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.mining.Boring;
import me.ultra42.ultraskills.abilities.mining.Quarry;
import me.ultra42.ultraskills.abilities.mining.TunnelRat;
import me.ultra42.ultraskills.tools.Tool;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.util.Vector;

public class Pickaxe
extends Tool {
    private static String name = "Pickaxe";
    static HashMap<String, String> mode_rotation = new HashMap();
    static List<String> mode_list = Arrays.asList("None", "TunnelRat", "Boring", "Quarry");

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Pickaxe(), p);
        Pickaxe.loadModes();
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Material material = itemStack.getType();
        return material == Material.WOODEN_PICKAXE || material == Material.STONE_PICKAXE || material == Material.IRON_PICKAXE || material == Material.GOLDEN_PICKAXE || material == Material.DIAMOND_PICKAXE || material == Material.NETHERITE_PICKAXE;
    }

    @EventHandler
    private void onMineWithPickaxe(BlockBreakEvent e) {
        Player p = e.getPlayer();
        Block b = e.getBlock();
        if (!Pickaxe.isPickaxe(p.getInventory().getItemInMainHand())) {
            return;
        }
        UltraBlock.giveXP(p, b);
        String mode = PersistentDataUtility.readString((Entity)p, "pickaxe_mode", "None");
        assert (mode != null);
        this.cast(e, mode, false);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && Pickaxe.isPickaxe(event.getItem())) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            BlockFace face = event.getBlockFace();
            if (block != null && block.getType() != Material.AIR) {
                PersistentDataUtility.store(player, "mining_face", face.name());
            }
        }
    }

    public static void loadModes() {
        for (int i = 0; i < mode_list.size(); ++i) {
            String str = mode_list.get(i);
            if (i == mode_list.size() - 1) {
                mode_rotation.put(mode_list.get(i), mode_list.get(0));
                continue;
            }
            mode_rotation.put(mode_list.get(i), mode_list.get(i + 1));
        }
    }

    public static void displayToolUI(Player p, String mode) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard board = manager.getNewScoreboard();
        Objective obj = board.registerNewObjective("ToolScoreboard", Criteria.DUMMY, (Component)Component.text((String)"Mode Selected:"));
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        int count = 0;
        for (String s : mode_list) {
            if (!AbilityManager.hasAbility(p, s) && !s.equals("None")) continue;
            Score score = s.equals(mode) ? obj.getScore(ChatColor.YELLOW + s) : obj.getScore(ChatColor.WHITE + s);
            score.setScore(count);
            ++count;
        }
        p.setScoreboard(board);
    }

    public static String rotateMode(String mode) {
        return mode_rotation.get(mode);
    }

    public static String rotateMode(Player p, String mode, boolean reverse) {
        int i = mode_list.indexOf(mode);
        mode = reverse && i == 0 ? mode_list.get(mode_list.size() - 1) : (reverse ? mode_list.get(i - 1) : (i == mode_list.size() - 1 ? mode_list.get(0) : mode_list.get(i + 1)));
        if (!AbilityManager.hasAbility(p, mode) && !mode.equals("None")) {
            return Pickaxe.rotateMode(p, mode, reverse);
        }
        return mode;
    }

    public void cast(BlockBreakEvent e, String mode, boolean isSecondary) {
        switch (mode) {
            case "None": {
                DebugUtility.consoleMessage("Block mined normally.", 5);
                break;
            }
            case "TunnelRat": {
                TunnelRat.cast(e, isSecondary);
                break;
            }
            case "Boring": {
                Boring.cast(e, isSecondary);
                break;
            }
            case "Quarry": {
                Quarry.cast(e, isSecondary);
            }
        }
    }

    @EventHandler
    public void onPlayerSwitchItem(PlayerSwapHandItemsEvent e) {
        final Player p = e.getPlayer();
        if (Pickaxe.isPickaxe(e.getMainHandItem()) || Pickaxe.isPickaxe(e.getOffHandItem())) {
            e.setCancelled(true);
            String mode = Pickaxe.rotateMode(p, PersistentDataUtility.readString((Entity)p, "pickaxe_mode", "None"), !p.isSneaking());
            PersistentDataUtility.store(p, "pickaxe_mode", mode);
            Pickaxe.displayToolUI(p, mode);
            AbilityManager.putCooldown(p, name, 500);
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.5f);
            new BukkitRunnable(){

                public void run() {
                    Instant cd = AbilityManager.getCooldown(p, name).plusSeconds(5L);
                    if (cd != null && cd.isBefore(Instant.now())) {
                        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
                        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
                        p.setScoreboard(scoreboard);
                        this.cancel();
                    } else if (cd == null) {
                        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
                        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
                        p.setScoreboard(scoreboard);
                        this.cancel();
                    }
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 20L);
        }
    }

    private String getBlockFace(Vector direction) {
        double x = Math.abs(direction.getX());
        double y = Math.abs(direction.getY());
        double z = Math.abs(direction.getZ());
        if (y > x && y > z) {
            return direction.getY() > 0.0 ? "top" : "bottom";
        }
        if (x > z) {
            return direction.getX() > 0.0 ? "east" : "west";
        }
        return direction.getZ() > 0.0 ? "south" : "north";
    }
}

