/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.tools;

import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.ranged.Cupid;
import me.ultra42.ultraskills.tools.Tool;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class Bow
extends Tool {
    private static String name = "Bow";
    private static Material type = Material.BOW;
    static HashMap<String, String> mode_rotation = new HashMap();
    static List<String> mode_list = Arrays.asList("None", "Cupid");

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Bow(), p);
        Bow.loadModes();
    }

    public static boolean getType(Material m) {
        return m.equals((Object)type);
    }

    public static boolean isBow(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.getType().equals((Object)type);
    }

    @EventHandler
    private void onRightClickBow(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !e.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        if (!(Objects.equals(e.getHand(), EquipmentSlot.HAND) && Bow.isBow(e.getPlayer().getInventory().getItemInMainHand()) || Objects.equals(e.getHand(), EquipmentSlot.OFF_HAND) && Bow.isBow(e.getPlayer().getInventory().getItemInOffHand()))) {
            return;
        }
        if (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else if (e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else {
            return;
        }
        String mode = PersistentDataUtility.readString((Entity)p, "bow_mode", "None");
        assert (mode != null);
        this.cast((Event)e, mode, false);
    }

    @EventHandler
    private void onLeftClickTool(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!AbilityManager.hasAbility(p, name) || !AbilityManager.isOffCooldown(p, name)) {
            return;
        }
        if (!e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR)) {
            return;
        }
        if (!(e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)type) || e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)type))) {
            return;
        }
        if (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else if (e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)type)) {
            ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        } else {
            return;
        }
        String mode = PersistentDataUtility.readString((Entity)p, "bow_mode", "None");
        assert (mode != null);
        this.cast((Event)e, mode, true);
    }

    @EventHandler
    private void onProjectileLaunch(ProjectileLaunchEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player p = (Player)projectileSource;
        String mode = PersistentDataUtility.readString((Entity)p, "bow_mode", "None");
        assert (mode != null);
        this.cast((Event)event, mode, false);
    }

    public static void loadModes() {
        for (int i = 0; i < mode_list.size(); ++i) {
            String str = mode_list.get(i);
            if (i == mode_list.size() - 1) {
                mode_rotation.put(mode_list.get(i), mode_list.get(0));
                continue;
            }
            mode_rotation.put(mode_list.get(i), mode_list.get(i + 1));
        }
    }

    public static void displayToolUI(Player p, String mode) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard board = manager.getNewScoreboard();
        Objective obj = board.registerNewObjective("ToolScoreboard", Criteria.DUMMY, (Component)Component.text((String)"Mode Selected:"));
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        int count = 0;
        for (String s : mode_list) {
            if (!AbilityManager.hasAbility(p, s) && !s.equals("None")) continue;
            Score score = s.equals(mode) ? obj.getScore(ChatColor.YELLOW + s) : obj.getScore(ChatColor.WHITE + s);
            score.setScore(count);
            ++count;
        }
        p.setScoreboard(board);
    }

    public static String rotateMode(String mode) {
        return mode_rotation.get(mode);
    }

    public static String rotateMode(Player p, String mode, boolean reverse) {
        int i = mode_list.indexOf(mode);
        mode = reverse && i == 0 ? mode_list.get(mode_list.size() - 1) : (reverse ? mode_list.get(i - 1) : (i == mode_list.size() - 1 ? mode_list.get(0) : mode_list.get(i + 1)));
        if (!AbilityManager.hasAbility(p, mode) && !mode.equals("None")) {
            return Bow.rotateMode(p, mode, reverse);
        }
        return mode;
    }

    public void cast(Event e, String mode, boolean isSecondary) {
        switch (mode) {
            case "None": {
                DebugUtility.consoleMessage("Projectile primed normally.", 5);
                break;
            }
            case "Cupid": {
                Cupid.cast(e, isSecondary);
            }
        }
    }

    @EventHandler
    public void onPlayerSwitchItem(PlayerSwapHandItemsEvent e) {
        final Player p = e.getPlayer();
        if (Bow.isBow(e.getMainHandItem()) || Bow.isBow(e.getOffHandItem())) {
            e.setCancelled(true);
            String mode = Bow.rotateMode(p, PersistentDataUtility.readString((Entity)p, "bow_mode", "None"), !p.isSneaking());
            PersistentDataUtility.store(p, "bow_mode", mode);
            Bow.displayToolUI(p, mode);
            AbilityManager.putCooldown(p, name, 500);
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.5f);
            new BukkitRunnable(){

                public void run() {
                    Instant cd = AbilityManager.getCooldown(p, name).plusSeconds(5L);
                    if (cd != null && cd.isBefore(Instant.now())) {
                        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
                        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
                        p.setScoreboard(scoreboard);
                        this.cancel();
                    } else if (cd == null) {
                        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
                        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
                        p.setScoreboard(scoreboard);
                        this.cancel();
                    }
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 20L);
        }
    }
}

