/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.skillgroups;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.menusystem.XPBossBars;
import me.ultra42.ultraskills.menusystem.menu.Menu;
import me.ultra42.ultraskills.skillgroups.General;
import me.ultra42.ultraskills.utilities.BlockXPUtility;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.croptrample.CropTrampleListener;
import me.ultra42.ultraskills.utilities.pressureplate.PressurePlateListener;
import me.ultra42.ultraskills.utilities.ubb.UltraBlockBreakListener;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SkillGroup
implements Listener {
    protected static int level1 = 1000;
    protected static double scalingFactor = 1.15;
    static HashMap<Integer, Integer> level_reqs = new HashMap();
    private static final int first_level = 100;
    private static final double exponent = 2.0;

    public static int getLevel1() {
        return level1;
    }

    public static double getScalingFactor() {
        return scalingFactor;
    }

    public static NamedTextColor getSkillColor(String skill_group_name) {
        switch (skill_group_name) {
            case "General": {
                return NamedTextColor.GRAY;
            }
            case "Agility": {
                return NamedTextColor.WHITE;
            }
            case "Mining": {
                return NamedTextColor.DARK_GRAY;
            }
            case "Farming": {
                return NamedTextColor.GREEN;
            }
            case "Foraging": {
                return NamedTextColor.DARK_GREEN;
            }
            case "Defense": {
                return NamedTextColor.BLUE;
            }
            case "Melee": {
                return NamedTextColor.RED;
            }
            case "Ranged": {
                return NamedTextColor.GOLD;
            }
            case "Trinkets": {
                return NamedTextColor.YELLOW;
            }
            case "Magic": {
                return NamedTextColor.LIGHT_PURPLE;
            }
            case "Games": {
                return NamedTextColor.DARK_PURPLE;
            }
            case "Crafting": {
                return NamedTextColor.AQUA;
            }
        }
        return NamedTextColor.GRAY;
    }

    public static BossBar.Color getBarColor(String skill_group_name) {
        switch (skill_group_name) {
            case "General": {
                return BossBar.Color.YELLOW;
            }
            case "Agility": {
                return BossBar.Color.WHITE;
            }
            case "Mining": {
                return BossBar.Color.WHITE;
            }
            case "Farming": {
                return BossBar.Color.GREEN;
            }
            case "Foraging": {
                return BossBar.Color.GREEN;
            }
            case "Defense": {
                return BossBar.Color.BLUE;
            }
            case "Melee": {
                return BossBar.Color.RED;
            }
            case "Ranged": {
                return BossBar.Color.RED;
            }
            case "Trinkets": {
                return BossBar.Color.YELLOW;
            }
            case "Magic": {
                return BossBar.Color.PURPLE;
            }
            case "Games": {
                return BossBar.Color.PURPLE;
            }
            case "Crafting": {
                return BossBar.Color.YELLOW;
            }
        }
        return BossBar.Color.WHITE;
    }

    public static Sound getSkillSound(String skill_group_name) {
        switch (skill_group_name) {
            case "General": {
                return Sound.UI_TOAST_CHALLENGE_COMPLETE;
            }
            case "Agility": {
                return Sound.ENTITY_DOLPHIN_JUMP;
            }
            case "Mining": {
                return Sound.ENTITY_VILLAGER_WORK_TOOLSMITH;
            }
            case "Farming": {
                return Sound.ITEM_HOE_TILL;
            }
            case "Foraging": {
                return Sound.BLOCK_SWEET_BERRY_BUSH_PICK_BERRIES;
            }
            case "Defense": {
                return Sound.ITEM_SHIELD_BLOCK;
            }
            case "Melee": {
                return Sound.ENTITY_PLAYER_ATTACK_CRIT;
            }
            case "Ranged": {
                return Sound.ENTITY_ARROW_HIT;
            }
            case "Trinkets": {
                return Sound.ITEM_SPYGLASS_USE;
            }
            case "Magic": {
                return Sound.BLOCK_BREWING_STAND_BREW;
            }
            case "Games": {
                return Sound.UI_CARTOGRAPHY_TABLE_TAKE_RESULT;
            }
            case "Crafting": {
                return Sound.UI_STONECUTTER_TAKE_RESULT;
            }
        }
        return Sound.ENTITY_ENDERMAN_TELEPORT;
    }

    public static Material getSkillGlassPane(String skill_group_name) {
        switch (skill_group_name) {
            case "General": {
                return Material.LIGHT_GRAY_STAINED_GLASS_PANE;
            }
            case "Agility": {
                return Material.WHITE_STAINED_GLASS_PANE;
            }
            case "Mining": {
                return Material.GRAY_STAINED_GLASS_PANE;
            }
            case "Farming": {
                return Material.LIME_STAINED_GLASS_PANE;
            }
            case "Foraging": {
                return Material.GREEN_STAINED_GLASS_PANE;
            }
            case "Defense": {
                return Material.BLUE_STAINED_GLASS_PANE;
            }
            case "Melee": {
                return Material.RED_STAINED_GLASS_PANE;
            }
            case "Ranged": {
                return Material.ORANGE_STAINED_GLASS_PANE;
            }
            case "Trinkets": {
                return Material.YELLOW_STAINED_GLASS_PANE;
            }
            case "Magic": {
                return Material.MAGENTA_STAINED_GLASS_PANE;
            }
            case "Games": {
                return Material.PURPLE_STAINED_GLASS_PANE;
            }
            case "Crafting": {
                return Material.CYAN_STAINED_GLASS_PANE;
            }
        }
        return Material.FIRE;
    }

    public void register(Plugin p, PluginManager m) {
        UltraSkills.getPlugin().getLogger().info("ERROR - Generic skill group registered");
    }

    public static int registerSkillGroups(String packageName) {
        SkillGroup.generateLevelRequirements(100, 2.0);
        XPBossBars.register((Plugin)UltraSkills.getPlugin(), Bukkit.getServer().getPluginManager());
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new UltraBlockBreakListener(), (Plugin)UltraSkills.getPlugin());
        BlockXPUtility.registerBlockXP();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new CropTrampleListener(), (Plugin)UltraSkills.getPlugin());
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PressurePlateListener(), (Plugin)UltraSkills.getPlugin());
        int count = 0;
        for (Class<SkillGroup> clazz : new Reflections(packageName + ".skillgroups", new Scanner[0]).getSubTypesOf(SkillGroup.class)) {
            try {
                DebugUtility.consoleMessage("[SkillGroups] Registering " + clazz.getName(), 4);
                SkillGroup skillgroup = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Class[] cArg = new Class[]{Plugin.class, PluginManager.class};
                Method m = skillgroup.getClass().getMethod("register", cArg);
                m.invoke((Object)skillgroup, new Object[]{UltraSkills.getPlugin(), Bukkit.getServer().getPluginManager()});
                ++count;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return count;
    }

    public static HashMap<Integer, ItemStack> getSkillTreeHeader(String skill_group_name) {
        HashMap<Integer, ItemStack> skillTreeHeader = new HashMap<Integer, ItemStack>();
        skillTreeHeader.put(1, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 1));
        skillTreeHeader.put(2, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 5));
        skillTreeHeader.put(3, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 10));
        skillTreeHeader.put(4, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 15));
        skillTreeHeader.put(5, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 20));
        skillTreeHeader.put(6, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 25));
        skillTreeHeader.put(7, Menu.createItem((Component)Component.text((String)""), SkillGroup.getSkillGlassPane(skill_group_name), null, 30));
        return skillTreeHeader;
    }

    public static int getXP(Player p, String skill_group_name) {
        return UltraSkills.getData().getConfig().getInt("players." + p.getUniqueId() + "." + skill_group_name);
    }

    public static int getSkillPoints(Player p, String skill_group_name) {
        int lvl = SkillGroup.getLevel(p, skill_group_name);
        int points = lvl / 5;
        return points + 1;
    }

    public static void giveXP(Player p, String skill_group_name, int amount, String reason) {
        if (p.getGameMode() != GameMode.SURVIVAL && p.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (amount == 0) {
            return;
        }
        int current = 0;
        if (UltraSkills.getData().getConfig().contains("players." + p.getUniqueId() + "." + skill_group_name)) {
            current = UltraSkills.getData().getConfig().getInt("players." + p.getUniqueId() + "." + skill_group_name);
        }
        UltraSkills.getData().getConfig().set("players." + p.getUniqueId() + "." + skill_group_name, (Object)(current + amount));
        UltraSkills.getData().saveConfig();
        if (skill_group_name == "General") {
            General.updateGeneralXP(p);
            return;
        }
        SkillGroup.giveXP(p, "General", amount, skill_group_name);
        SkillGroup.checkLevelUp(p, skill_group_name, current, amount);
        TextComponent bossBarTitle = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)(skill_group_name + " "), (TextColor)SkillGroup.getSkillColor(skill_group_name)).append((Component)Component.text((int)SkillGroup.getLevel(current), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"     "))).append((Component)Component.text((String)reason, (TextColor)TextColor.color((int)3487804), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)Component.text((String)(" +" + amount + "xp"), (TextColor)NamedTextColor.YELLOW));
        BossBar b = BossBar.bossBar((Component)bossBarTitle, (float)SkillGroup.getNextLevelPercent(SkillGroup.getXP(p, skill_group_name)), (BossBar.Color)SkillGroup.getBarColor(skill_group_name), (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
        XPBossBars.showXPBar(p, skill_group_name, amount, reason);
    }

    public static void checkLevelUp(Player p, String skill_group_name, int currentXP, int incomingXP) {
        for (int i = 1; i <= 30; ++i) {
            int requiredXP = SkillGroup.getLevelRequirement(i, skill_group_name);
            if (currentXP < requiredXP && currentXP + incomingXP >= requiredXP) {
                p.playSound(p.getLocation(), SkillGroup.getSkillSound(skill_group_name), 10.0f, 4.0f);
                TextComponent mainTitle = Component.text((String)(skill_group_name + " " + i), (TextColor)SkillGroup.getSkillColor(skill_group_name));
                TextComponent subTitle = Component.text((String)(currentXP + incomingXP + "/" + SkillGroup.getLevelRequirement(i + 1) + " to level " + (SkillGroup.getLevel(currentXP) + 1)), (TextColor)NamedTextColor.WHITE);
                Title levelUpTitle = Title.title((Component)mainTitle, (Component)subTitle, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L)));
                p.showTitle(levelUpTitle);
                continue;
            }
            if (currentXP >= requiredXP) continue;
            return;
        }
    }

    public static void generateLevelRequirements(int first_level, double exponent) {
        level_reqs.put(0, 0);
        for (int x = 1; x <= 100; ++x) {
            level_reqs.put(x, (int)((double)first_level * Math.pow(x, exponent)));
        }
    }

    public static int getLevelRequirement(int level) {
        return (int)(100.0 * Math.pow(level, 2.0));
    }

    public static int getLevelRequirement(int level, String skill_group_name) {
        if (Objects.equals(skill_group_name, "General")) {
            return SkillGroup.getLevelRequirement(level) * 10;
        }
        return SkillGroup.getLevelRequirement(level);
    }

    public static int getLevel(int experience, String skill_group_name) {
        int level = 0;
        int requiredExperience;
        while ((requiredExperience = SkillGroup.getLevelRequirement(level, skill_group_name)) <= experience) {
            ++level;
        }
        return level - 1;
    }

    public static int getLevel(int experience) {
        int level = 0;
        int requiredExperience;
        while ((requiredExperience = SkillGroup.getLevelRequirement(level)) <= experience) {
            ++level;
        }
        return level - 1;
    }

    public static int getLevel(Player p, String skillTreeName) {
        int xp = SkillGroup.getXP(p, skillTreeName);
        return SkillGroup.getLevel(xp, skillTreeName);
    }

    public static float getNextLevelPercent(int currentXP) {
        int level = SkillGroup.getLevel(currentXP);
        int xp_max_in_level = SkillGroup.getLevelRequirement(level + 1) - SkillGroup.getLevelRequirement(level);
        int xp_this_level = currentXP - SkillGroup.getLevelRequirement(level);
        return 1.0f * (float)xp_this_level / (float)xp_max_in_level;
    }

    public static void setXP(Player p, String skill_group_name, int amount) {
        UltraSkills.getData().getConfig().set("players." + p.getUniqueId() + "." + skill_group_name, (Object)amount);
        p.sendMessage("Set " + p.getName() + "'s " + skill_group_name + " XP to " + amount);
        SkillGroup.checkLevelUp(p, skill_group_name, 0, amount);
        UltraSkills.getData().saveConfig();
    }

    public static void setLevel(Player p, String skill_group_name, int level) {
        int xp_amount = SkillGroup.getLevelRequirement(level, skill_group_name);
        SkillGroup.setXP(p, skill_group_name, xp_amount);
    }
}

