/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.skillgroups;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.DebugUtility;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class Magic
extends SkillGroup {
    static String skill_group_name = "Magic";
    public static final Set<EntityDamageEvent.DamageCause> EXCLUDED_DAMAGE_CAUSES = EnumSet.of(EntityDamageEvent.DamageCause.SUFFOCATION, new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.DROWNING, EntityDamageEvent.DamageCause.SUICIDE, EntityDamageEvent.DamageCause.STARVATION, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.CUSTOM, EntityDamageEvent.DamageCause.CRAMMING, EntityDamageEvent.DamageCause.DRYOUT});

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Magic(), p);
    }

    public static HashMap<Integer, ItemStack> getSkillTree(Player p) {
        HashMap<Integer, ItemStack> skillTree = new HashMap<Integer, ItemStack>();
        ArrayList<TextComponent> coming_soon_lore = new ArrayList<TextComponent>();
        coming_soon_lore.add(Component.text((String)"Coming soon..."));
        return skillTree;
    }

    public static int getXP(Player p) {
        return Magic.getXP(p, skill_group_name);
    }

    @EventHandler
    public void onEnchant(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        ItemStack item = event.getItem();
        int expCost = event.getExpLevelCost();
        if (item.getType() == Material.ENCHANTED_BOOK) {
            Enchantment enchantment = (Enchantment)item.getEnchantments().keySet().iterator().next();
            DebugUtility.devMessage("You have created an enchanted book with " + enchantment.getName() + " enchantment!", 2);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("You have enchanted ");
            sb.append(item.getType().name());
            sb.append(" with ");
            for (Enchantment enchantment : event.getEnchantsToAdd().keySet()) {
                sb.append(enchantment.getName());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" at a cost of ");
            sb.append(expCost);
            sb.append(" levels.");
            DebugUtility.devMessage(sb.toString(), 2);
            Magic.giveXP(player, skill_group_name, expCost * 25, "ENCHANTING");
        }
    }

    @EventHandler
    public void onDamagedWithEnchantedArmor(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getFinalDamage() <= 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (EXCLUDED_DAMAGE_CAUSES.contains(event.getCause())) {
            return;
        }
        int totalEnchantments = 0;
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            totalEnchantments += item.getEnchantments().size();
        }
        int xp = (int)((double)totalEnchantments * event.getDamage());
        String text = player.getName() + " took damage with total of " + totalEnchantments + " enchantments on their armor. (+" + xp + "xp)";
        DebugUtility.consoleMessage(text, 3);
        Magic.giveXP(player, skill_group_name, xp, "ENCHANTED_ARMOR");
    }

    @EventHandler
    public void onAttackWithEnchantedWeapon(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            Entity entity = event.getEntity();
            ItemStack weapon = player.getInventory().getItemInMainHand();
            if (weapon.getType().isItem() && weapon.getItemMeta().hasEnchants()) {
                int totalEnchantments = weapon.getEnchantments().size();
                int xp = (int)((double)totalEnchantments * event.getDamage());
                String text = player.getName() + " attacked with a " + weapon.getType().name() + " with a total of " + totalEnchantments + " enchantments. (+" + xp + "xp)";
                DebugUtility.consoleMessage(text, 3);
                Magic.giveXP(player, skill_group_name, xp, "ENCHANTED_WEAPON");
            }
        } else {
            Entity player = event.getDamager();
            if (player instanceof Arrow) {
                Player player2;
                Arrow arrow = (Arrow)player;
                Entity entity = event.getEntity();
                ProjectileSource weapon = arrow.getShooter();
                if (weapon instanceof Player && ((weapon = (player2 = (Player)weapon).getInventory().getItemInMainHand()).getType() == Material.BOW || weapon.getType() == Material.CROSSBOW) && weapon.getItemMeta().hasEnchants()) {
                    int totalEnchantments = 0;
                    if (weapon.getItemMeta().hasEnchant(Enchantment.ARROW_DAMAGE)) {
                        totalEnchantments += weapon.getItemMeta().getEnchantLevel(Enchantment.ARROW_DAMAGE);
                    }
                    if (weapon.getItemMeta().hasEnchant(Enchantment.ARROW_FIRE)) {
                        totalEnchantments += weapon.getItemMeta().getEnchantLevel(Enchantment.ARROW_FIRE);
                    }
                    if (weapon.getItemMeta().hasEnchant(Enchantment.ARROW_INFINITE)) {
                        totalEnchantments += weapon.getItemMeta().getEnchantLevel(Enchantment.ARROW_INFINITE);
                    }
                    if (weapon.getItemMeta().hasEnchant(Enchantment.ARROW_KNOCKBACK)) {
                        totalEnchantments += weapon.getItemMeta().getEnchantLevel(Enchantment.ARROW_KNOCKBACK);
                    }
                    int xp = (int)((double)totalEnchantments * event.getDamage());
                    String text = player2.getName() + " attacked with a " + weapon.getType().name() + " with a total of " + totalEnchantments + " enchantments. (+" + xp + "xp)";
                    DebugUtility.consoleMessage(text, 3);
                    Magic.giveXP(player2, skill_group_name, xp, "ENCHANTED_WEAPON");
                }
            }
        }
    }

    @EventHandler
    public void onBreakBlockWithEnchantedTool(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && !item.getEnchantments().isEmpty()) {
            int numEnchants = item.getEnchantments().size();
            if (event.getBlock().getType() != Material.AIR) {
                int xp = numEnchants;
                String text = player.getName() + " used an enchanted " + item.getType().name() + " with " + numEnchants + " enchantment(s) to break a block. (+" + xp + "xp)";
                DebugUtility.consoleMessage(text, 3);
                Magic.giveXP(player, skill_group_name, xp, "ENCHANTED_TOOL");
            }
        }
    }

    @EventHandler
    public void onPotionDrink(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemMeta itemMeta = event.getItem().getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            int amplifier;
            PotionMeta meta = (PotionMeta)itemMeta;
            PotionData potionData = meta.getBasePotionData();
            PotionType potionType = potionData.getType();
            PotionEffectType type = potionType.getEffectType();
            int n = amplifier = potionData.isUpgraded() ? 1 : 0;
            if (!meta.getCustomEffects().isEmpty()) {
                for (PotionEffect effect : meta.getCustomEffects()) {
                    type = effect.getType();
                    amplifier = effect.getAmplifier();
                }
            }
            int xp = (1 + amplifier) * 100;
            if (potionData.isExtended()) {
                xp *= 2;
            }
            if (potionData.isUpgraded()) {
                xp *= 2;
            }
            String text = player.getName() + " consumed a " + potionType.toString().toLowerCase() + " potion of " + type.getName() + " with an amplifier level of " + amplifier + ". Extended: " + potionData.isExtended() + " Upgraded: " + potionData.isUpgraded() + " (+" + xp + "xp)";
            DebugUtility.consoleMessage(text, 3);
            Magic.giveXP(player, skill_group_name, xp, type.getName());
        }
    }

    @EventHandler
    public void onPotionThrow(ProjectileLaunchEvent event) {
        if (event.getEntity() instanceof ThrownPotion && event.getEntity().getShooter() instanceof Player) {
            Player player = (Player)event.getEntity().getShooter();
            ThrownPotion thrownPotion = (ThrownPotion)event.getEntity();
            ItemStack itemStack = thrownPotion.getItem();
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof PotionMeta) {
                int amplifier;
                PotionMeta meta = (PotionMeta)itemMeta;
                PotionData potionData = meta.getBasePotionData();
                PotionType potionType = potionData.getType();
                PotionEffectType type = potionType.getEffectType();
                int n = amplifier = potionData.isUpgraded() ? 1 : 0;
                if (!meta.getCustomEffects().isEmpty()) {
                    for (PotionEffect effect : meta.getCustomEffects()) {
                        type = effect.getType();
                        amplifier = effect.getAmplifier();
                    }
                }
                int xp = (1 + amplifier) * 150;
                if (potionData.isExtended()) {
                    xp *= 2;
                }
                if (potionData.isUpgraded()) {
                    xp *= 2;
                }
                String text = player.getName() + " threw a " + potionType.toString().toLowerCase() + " potion of " + type.getName() + " with an amplifier level of " + amplifier + ". Extended: " + potionData.isExtended() + " Upgraded: " + potionData.isUpgraded() + " (+" + xp + "xp)";
                DebugUtility.consoleMessage(text, 3);
                Magic.giveXP(player, skill_group_name, xp, type.getName());
            }
        }
    }
}

