/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.skillgroups;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.ubb.BlockChangeManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Farming
extends SkillGroup {
    static String skill_group_name = "Farming";
    public static Set<Material> farming_crops = EnumSet.of(Material.WHEAT, new Material[]{Material.BEETROOTS, Material.SWEET_BERRY_BUSH, Material.PUMPKIN, Material.CACTUS, Material.SUGAR_CANE, Material.CARROTS, Material.POTATOES, Material.MELON});

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Farming(), p);
    }

    public static HashMap<Integer, ItemStack> getSkillTree(Player p) {
        HashMap<Integer, ItemStack> skillTree = new HashMap<Integer, ItemStack>();
        ArrayList<TextComponent> coming_soon_lore = new ArrayList<TextComponent>();
        coming_soon_lore.add(Component.text((String)"Coming soon..."));
        return skillTree;
    }

    public static int getXP(Player p) {
        return Farming.getXP(p, skill_group_name);
    }

    @EventHandler
    public void onHarvest(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (farming_crops.contains(e.getBlock().getType()) && BlockChangeManager.isManMade(e.getBlock().getLocation(), e.getBlock().getWorld())) {
            int xp = 10;
            if ((e.getBlock().getType() == Material.MELON || e.getBlock().getType() == Material.PUMPKIN) && e.getPlayer().getInventory().getItemInMainHand().containsEnchantment(Enchantment.SILK_TOUCH)) {
                return;
            }
            Farming.giveXP(p, skill_group_name, xp, e.getBlock().getType().name());
            Location loc = e.getBlock().getLocation();
            String block_name = loc.getBlockX() + "/" + loc.getBlockY() + "/" + loc.getBlockZ();
            NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), block_name);
            String planter_name = (String)e.getBlock().getChunk().getPersistentDataContainer().get(key, PersistentDataType.STRING);
            if (!Objects.equals(planter_name, p.getName())) {
                Farming.giveXP(UltraSkills.getPlugin().getServer().getPlayer(planter_name), skill_group_name, xp, p.getName());
            }
        }
    }

    @EventHandler
    public void onGrow(BlockGrowEvent e) {
        if (e.isCancelled()) {
            return;
        }
    }

    @EventHandler
    public void onBreed(EntityBreedEvent e) {
        if (e.isCancelled()) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "bred-by-players");
        String player_name = e.getBreeder().getName();
        e.getEntity().getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)player_name);
        if (e.getBreeder() != null) {
            Player p = (Player)e.getBreeder();
            int xp = 100;
            p.sendMessage((String)e.getEntity().getPersistentDataContainer().get(key, PersistentDataType.STRING));
            e.getEntity().setGlowing(true);
            UltraSkills.getPlugin().getLogger().info("Giving farming XP:" + xp);
            Farming.giveXP(p, skill_group_name, xp, e.getEntity().getType().name());
        }
    }

    @EventHandler
    public void entityDeathEvent(EntityDeathEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntity().getKiller() == null) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "bred-by-players");
        Player p = e.getEntity().getKiller();
        if (e.getEntity().getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            int xp = 100;
            UltraSkills.getPlugin().getLogger().info("Giving farming XP:" + xp);
            Farming.giveXP(p, skill_group_name, xp, e.getEntity().getName());
            String breeder_name = (String)e.getEntity().getPersistentDataContainer().get(key, PersistentDataType.STRING);
            if (!Objects.equals(breeder_name, p.getName())) {
                Farming.giveXP(UltraSkills.getPlugin().getServer().getPlayer(breeder_name), skill_group_name, xp, p.getName());
            }
        }
    }
}

