/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.skillgroups;

import java.util.ArrayList;
import java.util.HashMap;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Crafting
extends SkillGroup {
    static String skill_group_name = "Crafting";
    static HashMap<Material, Integer> craftingXPValues = new HashMap();

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Crafting(), p);
        Crafting.createCraftingXPValues();
    }

    public static HashMap<Integer, ItemStack> getSkillTree(Player p) {
        HashMap<Integer, ItemStack> skillTree = new HashMap<Integer, ItemStack>();
        ArrayList<TextComponent> coming_soon_lore = new ArrayList<TextComponent>();
        coming_soon_lore.add(Component.text((String)"Coming soon..."));
        return skillTree;
    }

    public static int getXP(Player p) {
        return Crafting.getXP(p, skill_group_name);
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getRecipe().getResult().getType().equals((Object)Material.IRON_BLOCK)) {
            return;
        }
        ItemStack item = e.getCurrentItem();
        int xp = Crafting.getCraftingXPValues(item.getType()) * item.getAmount();
        Crafting.giveXP((Player)e.getWhoClicked(), skill_group_name, xp, e.getRecipe().getResult().getType().toString());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getClick().isShiftClick() || event.getSlotType() == InventoryType.SlotType.RESULT) {
            // empty if block
        }
    }

    public static void createCraftingXPValues() {
        craftingXPValues.put(Material.ACACIA_BOAT, 50);
        craftingXPValues.put(Material.BIRCH_BOAT, 50);
        craftingXPValues.put(Material.DARK_OAK_BOAT, 50);
        craftingXPValues.put(Material.JUNGLE_BOAT, 50);
        craftingXPValues.put(Material.MANGROVE_BOAT, 50);
        craftingXPValues.put(Material.OAK_BOAT, 50);
        craftingXPValues.put(Material.SPRUCE_BOAT, 50);
        craftingXPValues.put(Material.BOW, 50);
        craftingXPValues.put(Material.SHIELD, 200);
        craftingXPValues.put(Material.FISHING_ROD, 50);
        craftingXPValues.put(Material.CARROT_ON_A_STICK, 100);
        craftingXPValues.put(Material.CROSSBOW, 500);
        craftingXPValues.put(Material.FLINT_AND_STEEL, 50);
        craftingXPValues.put(Material.LEAD, 50);
        craftingXPValues.put(Material.SPYGLASS, 100);
        craftingXPValues.put(Material.SHEARS, 100);
        craftingXPValues.put(Material.FIREWORK_ROCKET, 100);
        craftingXPValues.put(Material.FIRE_CHARGE, 200);
        craftingXPValues.put(Material.FIREWORK_STAR, 300);
        craftingXPValues.put(Material.MINECART, 50);
        craftingXPValues.put(Material.BUCKET, 30);
        craftingXPValues.put(Material.ENDER_EYE, 100);
        craftingXPValues.put(Material.END_CRYSTAL, 1000);
        craftingXPValues.put(Material.BEACON, 2000);
        craftingXPValues.put(Material.PAINTING, 100);
        craftingXPValues.put(Material.ITEM_FRAME, 100);
        craftingXPValues.put(Material.GLOW_ITEM_FRAME, 100);
        craftingXPValues.put(Material.STICK, 5);
        craftingXPValues.put(Material.ARROW, 25);
        craftingXPValues.put(Material.BOOK, 50);
        craftingXPValues.put(Material.WRITABLE_BOOK, 150);
        craftingXPValues.put(Material.BOWL, 25);
        craftingXPValues.put(Material.BUNDLE, 250);
        craftingXPValues.put(Material.NAME_TAG, 100);
        craftingXPValues.put(Material.GLASS_BOTTLE, 50);
        craftingXPValues.put(Material.MAP, 200);
        craftingXPValues.put(Material.BEETROOT_SOUP, 100);
        craftingXPValues.put(Material.BREAD, 50);
        craftingXPValues.put(Material.SUSPICIOUS_STEW, 100);
        craftingXPValues.put(Material.MUSHROOM_STEW, 100);
        craftingXPValues.put(Material.PUMPKIN_PIE, 100);
        craftingXPValues.put(Material.RABBIT_STEW, 100);
        craftingXPValues.put(Material.GOLDEN_CARROT, 200);
        craftingXPValues.put(Material.GOLDEN_APPLE, 900);
        craftingXPValues.put(Material.BONE_MEAL, 25);
        craftingXPValues.put(Material.LEATHER_HELMET, 125);
        craftingXPValues.put(Material.LEATHER_CHESTPLATE, 200);
        craftingXPValues.put(Material.LEATHER_LEGGINGS, 175);
        craftingXPValues.put(Material.LEATHER_BOOTS, 100);
        craftingXPValues.put(Material.IRON_HELMET, 250);
        craftingXPValues.put(Material.IRON_CHESTPLATE, 400);
        craftingXPValues.put(Material.IRON_LEGGINGS, 350);
        craftingXPValues.put(Material.IRON_BOOTS, 200);
        craftingXPValues.put(Material.CHAINMAIL_HELMET, 500);
        craftingXPValues.put(Material.CHAINMAIL_CHESTPLATE, 800);
        craftingXPValues.put(Material.CHAINMAIL_LEGGINGS, 700);
        craftingXPValues.put(Material.CHAINMAIL_BOOTS, 400);
        craftingXPValues.put(Material.GOLDEN_HELMET, 500);
        craftingXPValues.put(Material.GOLDEN_CHESTPLATE, 800);
        craftingXPValues.put(Material.GOLDEN_LEGGINGS, 700);
        craftingXPValues.put(Material.GOLDEN_BOOTS, 400);
        craftingXPValues.put(Material.DIAMOND_HELMET, 1000);
        craftingXPValues.put(Material.DIAMOND_CHESTPLATE, 1600);
        craftingXPValues.put(Material.DIAMOND_LEGGINGS, 1400);
        craftingXPValues.put(Material.DIAMOND_BOOTS, 800);
        craftingXPValues.put(Material.NETHERITE_HELMET, 2000);
        craftingXPValues.put(Material.NETHERITE_CHESTPLATE, 3200);
        craftingXPValues.put(Material.NETHERITE_LEGGINGS, 2800);
        craftingXPValues.put(Material.NETHERITE_BOOTS, 1600);
        craftingXPValues.put(Material.WOODEN_SWORD, 50);
        craftingXPValues.put(Material.WOODEN_PICKAXE, 75);
        craftingXPValues.put(Material.WOODEN_AXE, 75);
        craftingXPValues.put(Material.WOODEN_SHOVEL, 25);
        craftingXPValues.put(Material.WOODEN_HOE, 50);
        craftingXPValues.put(Material.STONE_SWORD, 50);
        craftingXPValues.put(Material.STONE_PICKAXE, 75);
        craftingXPValues.put(Material.STONE_AXE, 75);
        craftingXPValues.put(Material.STONE_SHOVEL, 25);
        craftingXPValues.put(Material.STONE_HOE, 50);
        craftingXPValues.put(Material.IRON_SWORD, 100);
        craftingXPValues.put(Material.IRON_PICKAXE, 150);
        craftingXPValues.put(Material.IRON_AXE, 150);
        craftingXPValues.put(Material.IRON_SHOVEL, 50);
        craftingXPValues.put(Material.IRON_HOE, 100);
        craftingXPValues.put(Material.GOLDEN_SWORD, 200);
        craftingXPValues.put(Material.GOLDEN_PICKAXE, 300);
        craftingXPValues.put(Material.GOLDEN_AXE, 300);
        craftingXPValues.put(Material.GOLDEN_SHOVEL, 100);
        craftingXPValues.put(Material.GOLDEN_HOE, 200);
        craftingXPValues.put(Material.DIAMOND_SWORD, 400);
        craftingXPValues.put(Material.DIAMOND_PICKAXE, 600);
        craftingXPValues.put(Material.DIAMOND_AXE, 600);
        craftingXPValues.put(Material.DIAMOND_SHOVEL, 200);
        craftingXPValues.put(Material.DIAMOND_HOE, 400);
        craftingXPValues.put(Material.NETHERITE_SWORD, 800);
        craftingXPValues.put(Material.NETHERITE_PICKAXE, 1200);
        craftingXPValues.put(Material.NETHERITE_AXE, 1200);
        craftingXPValues.put(Material.NETHERITE_SHOVEL, 400);
        craftingXPValues.put(Material.NETHERITE_HOE, 800);
        craftingXPValues.put(Material.TURTLE_HELMET, 500);
    }

    public static int getCraftingXPValues(Material mat) {
        if (craftingXPValues.containsKey(mat)) {
            return craftingXPValues.get(mat);
        }
        return 0;
    }
}

