/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.skillgroups;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import java.util.ArrayList;
import java.util.HashMap;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.airborne.Airborne;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class Agility
extends SkillGroup {
    static String skill_group_name = "Agility";
    static HashMap<PlayerMoveEvent, Integer> agilityXPValues = new HashMap();
    static double sprinting_multiplier = 1.2;
    static double swimming_multiplier = 1.5;
    static double flying_multiplier = 2.0;
    int jump_value = 4;

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Agility(), p);
        m.registerEvents((Listener)new Airborne(), p);
        Agility.scheduler();
    }

    public static HashMap<Integer, ItemStack> getSkillTree(Player p) {
        HashMap<Integer, ItemStack> skillTree = new HashMap<Integer, ItemStack>();
        ArrayList<TextComponent> coming_soon_lore = new ArrayList<TextComponent>();
        coming_soon_lore.add(Component.text((String)"Coming soon..."));
        return skillTree;
    }

    public static int getXP(Player p) {
        return Agility.getXP(p, skill_group_name);
    }

    public static int getAgilityXPValues(EntityDamageEvent.DamageCause dc) {
        if (agilityXPValues.containsKey(dc)) {
            return agilityXPValues.get(dc);
        }
        UltraSkills.getPlugin().getLogger().info(dc.name() + " does not give Defense XP.");
        return 0;
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        int xp = this.jump_value;
        if (p.isSprinting()) {
            xp = (int)((double)xp * sprinting_multiplier);
        }
        Agility.giveXP(p, skill_group_name, xp, "JUMP");
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                int xp = 0;
                if (p.isFlying() || p.isGliding()) {
                    xp = (int)((double)(p.getWalkSpeed() * 10.0f) * flying_multiplier);
                    Agility.giveXP(p, skill_group_name, xp, "FLYING");
                    continue;
                }
                if (p.isSwimming()) {
                    xp = (int)((double)(p.getWalkSpeed() * 10.0f) * swimming_multiplier);
                    Agility.giveXP(p, skill_group_name, xp, "SWIMMING");
                    continue;
                }
                if (!p.isSprinting()) continue;
                xp = (int)((double)(p.getWalkSpeed() * 10.0f) * sprinting_multiplier);
                Agility.giveXP(p, skill_group_name, xp, "SPRINTING");
            }
        }, 0L, 20L);
    }
}

