/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.menusystem.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.menusystem.PlayerMenuUtility;
import me.ultra42.ultraskills.menusystem.menu.MainMenu;
import me.ultra42.ultraskills.menusystem.menu.Menu;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.AbilityManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SkillMenu
extends Menu {
    String skill_group_name;

    public SkillMenu(PlayerMenuUtility playerMenuUtility, String skill_group_name) {
        super(playerMenuUtility);
        this.skill_group_name = skill_group_name;
    }

    @Override
    public TextComponent getMenuName() {
        Player p = this.playerMenuUtility.getOwner();
        int xp = SkillGroup.getXP(p, this.skill_group_name);
        int lvl = SkillGroup.getLevel(xp, this.skill_group_name);
        return (TextComponent)((TextComponent)((TextComponent)Component.text((String)(this.skill_group_name + " "), (TextColor)SkillGroup.getSkillColor(this.skill_group_name)).append((Component)Component.text((String)(lvl + "  "), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((int)xp, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)("/" + SkillGroup.getLevelRequirement(lvl + 1, this.skill_group_name) + "xp"), (TextColor)NamedTextColor.DARK_GRAY));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        switch (e.getCurrentItem().getType()) {
            case BARRIER: {
                new MainMenu(UltraSkills.getPlayerMenuUtility(p)).open(p);
            }
        }
        int slot = e.getSlot();
        List<String> clickedOnSkill = SkillMeta.getSkillBySlot(slot, this.skill_group_name);
        if (!clickedOnSkill.isEmpty()) {
            String s = clickedOnSkill.get(0);
            if (AbilityManager.hasAbility(p, s)) {
                p.sendMessage("Removing point from " + s);
                AbilityManager.removeCooldown(p, s);
                p.playSound(p.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 4.0f, 4.0f);
            } else if (!AbilityManager.hasAbility(p, s) && SkillGroup.getLevel(p, this.skill_group_name) >= SkillMeta.getRequiredLevel(s)) {
                p.sendMessage("Unlocking " + s);
                AbilityManager.putCooldown(p, s, 0);
                p.playSound(p.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 4.0f, 4.0f);
            } else {
                p.sendMessage("Need " + this.skill_group_name + " level " + SkillMeta.getRequiredLevel(s));
            }
            new SkillMenu(UltraSkills.getPlayerMenuUtility(p), this.skill_group_name).open(p);
        }
    }

    @Override
    public void setMenuItems(Player p) {
        ArrayList<Component> coming_soon_lore = new ArrayList<Component>();
        coming_soon_lore.add((Component)Component.text((String)"Coming soon..."));
        int level = SkillGroup.getLevel(p, this.skill_group_name);
        this.inventory.setItem(53, SkillMenu.createItem((Component)Component.text((String)"Back to main menu"), Material.BARRIER, null, 1));
        for (int i = 1; i <= 50; ++i) {
            if (i <= level) continue;
            ItemStack item = Menu.createItem((Component)Component.text((String)("Level " + i)), Material.BLACK_STAINED_GLASS_PANE, coming_soon_lore, i);
            this.inventory.setItem(i, item);
        }
        SkillMeta.getAllItemsByTree().forEach((key, value) -> {
            if (Objects.equals(value, this.skill_group_name)) {
                int amount = SkillMeta.getSlot(key);
                if (amount == 0) {
                    amount = 1;
                }
                Component name = SkillMeta.getNameComponent(key);
                Material icon = SkillMeta.getIcon(key);
                ArrayList<Component> description = SkillMeta.getDescriptionComponent(key);
                int slot = SkillMeta.getSlot(key);
                ItemStack item = Menu.createItem(name, icon, description, amount);
                if (AbilityManager.hasAbility(p, key)) {
                    item.addUnsafeEnchantment(Enchantment.BINDING_CURSE, 1);
                } else if (level < slot) {
                    item.setType(SkillGroup.getSkillGlassPane(this.skill_group_name));
                }
                this.inventory.setItem(slot, item);
            }
        });
    }
}

