/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.menusystem.menu;

import java.util.ArrayList;
import java.util.List;
import me.ultra42.ultraskills.menusystem.PlayerMenuUtility;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Menu
implements InventoryHolder {
    protected Inventory inventory;
    protected PlayerMenuUtility playerMenuUtility;

    public Menu(PlayerMenuUtility playerMenuUtility) {
        this.playerMenuUtility = playerMenuUtility;
    }

    public abstract TextComponent getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void setMenuItems(Player var1);

    public static ItemStack createItem(Component name, Material mat, List<Component> lore, int amount) {
        if (amount <= 0) {
            amount = 1;
            mat = Material.TINTED_GLASS;
        }
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        if (lore == null) {
            ArrayList<TextComponent> null_lore = new ArrayList<TextComponent>();
            null_lore.add(Component.text((String)" ", (TextColor)NamedTextColor.GRAY));
            meta.lore(null_lore);
        } else {
            meta.lore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(Component name, Material mat, List<Component> lore) {
        return Menu.createItem(name, mat, lore, 1);
    }

    public void open(Player p) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (Component)this.getMenuName());
        this.setMenuItems(p);
        this.playerMenuUtility.getOwner().openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

