/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.menusystem;

import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.DebugUtility;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class XPBossBars
implements Listener {
    private static HashMap<UUID, BossBar> playerXPBars = new HashMap();
    private static HashMap<UUID, Instant> playerXPTimers = new HashMap();
    private static HashMap<UUID, Audience> playerXPAudiences = new HashMap();

    public static void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new XPBossBars(), p);
        XPBossBars.createPlayerXPAudiences();
    }

    public static void close() {
        for (Player p : UltraSkills.getPlugin().getServer().getOnlinePlayers()) {
            for (Map.Entry<UUID, BossBar> entry : playerXPBars.entrySet()) {
                p.hideBossBar(entry.getValue());
                playerXPBars.remove(entry.getKey());
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p;
        Player a = p = e.getPlayer();
        playerXPAudiences.put(p.getUniqueId(), (Audience)a);
        BossBar b = XPBossBars.welcomeBar(p);
        playerXPBars.put(p.getUniqueId(), b);
        XPBossBars.showBar(p, b);
    }

    public static void createPlayerXPAudiences() {
        Iterator iterator = UltraSkills.getPlugin().getServer().getOnlinePlayers().iterator();
        while (iterator.hasNext()) {
            Player p;
            Player a = p = (Player)iterator.next();
            playerXPAudiences.put(p.getUniqueId(), (Audience)a);
            BossBar b = XPBossBars.welcomeBar(p);
            playerXPBars.put(p.getUniqueId(), b);
        }
    }

    public static void showXPBar(Player p, String skill_group_name, int amount, String reason) {
        TextComponent bossBarTitle = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)(skill_group_name + " "), (TextColor)SkillGroup.getSkillColor(skill_group_name)).append((Component)Component.text((int)SkillGroup.getLevel(SkillGroup.getXP(p, skill_group_name) + amount), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"     "))).append((Component)Component.text((String)reason, (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)Component.text((String)(" +" + amount + "xp"), (TextColor)NamedTextColor.YELLOW));
        float progress = SkillGroup.getNextLevelPercent(SkillGroup.getXP(p, skill_group_name));
        BossBar.Color color = SkillGroup.getBarColor(skill_group_name);
        BossBar b = playerXPBars.get(p.getUniqueId());
        b.color(color);
        b.progress(progress);
        b.name((Component)bossBarTitle);
        b.overlay(BossBar.Overlay.NOTCHED_10);
        Audience a = playerXPAudiences.get(p.getUniqueId());
        XPBossBars.showBar(p, b);
    }

    public static BossBar welcomeBar(Player p) {
        TextComponent bossBarTitle = (TextComponent)Component.text((String)"General ", (TextColor)SkillGroup.getSkillColor("General")).append((Component)Component.text((int)SkillGroup.getLevel(SkillGroup.getXP(p, "General")), (TextColor)NamedTextColor.WHITE));
        float progress = (float)SkillGroup.getXP(p, "General") / ((float)SkillGroup.getLevelRequirement(50) * 10.0f);
        if (progress > 1.0f) {
            progress = 1.0f;
        } else if (progress < 0.0f) {
            progress = 0.0f;
        }
        BossBar.Color color = SkillGroup.getBarColor("General");
        BossBar b = BossBar.bossBar((Component)bossBarTitle, (float)progress, (BossBar.Color)color, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        return b;
    }

    public static void showBar(final Player p, BossBar b) {
        DebugUtility.consoleMessage("XPBossBar displaying for " + p.getName(), 4);
        playerXPTimers.put(p.getUniqueId(), Instant.now().plusMillis(2000L));
        final Audience a = playerXPAudiences.get(p.getUniqueId());
        a.showBossBar(b);
        new BukkitRunnable(){

            public void run() {
                if (playerXPTimers.get(p.getUniqueId()).isBefore(Instant.now())) {
                    DebugUtility.consoleMessage("XPBossBar hiding for " + p.getName(), 4);
                    BossBar bossBar = playerXPBars.get(p.getUniqueId());
                    if (bossBar != null) {
                        try {
                            a.hideBossBar(bossBar);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
                this.cancel();
            }
        }.runTaskTimerAsynchronously((Plugin)UltraSkills.getPlugin(), 45L, 20L);
    }
}

