/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.effects;

import java.time.Instant;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.effects.Effect;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Taunt
extends Effect {
    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Taunt(), p);
    }

    public static void tauntEntity(final Mob target_entity, int duration, final LivingEntity source) {
        DebugUtility.consoleMessage(source.getName() + " taunted " + target_entity.getType(), 2);
        Taunt.emitParticles((LivingEntity)target_entity);
        PersistentDataUtility.store((Entity)target_entity, "taunt", Instant.now().plusMillis((long)duration * 50L).toString());
        PersistentDataUtility.store((Entity)target_entity, "taunt-source", source.getUniqueId().toString());
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage("Taunt", 4);
                if (target_entity.isDead()) {
                    this.cancel();
                } else if (!Taunt.checkTaunt((LivingEntity)target_entity)) {
                    this.cancel();
                } else {
                    target_entity.setTarget(source);
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
    }

    public static boolean checkTaunt(LivingEntity entity) {
        if (entity.isDead()) {
            return false;
        }
        String taunt_end = PersistentDataUtility.readString((Entity)entity, "taunt", Instant.ofEpochMilli(0L).toString());
        return Instant.parse(taunt_end).isAfter(Instant.now());
    }

    public static void emitParticles(final LivingEntity l) {
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage("Taunt particles", 4);
                if (!Taunt.checkTaunt(l)) {
                    this.cancel();
                }
                l.getWorld().spawnParticle(Particle.WAX_ON, l.getEyeLocation(), 1, 0.5, 0.5, 0.5, 0.1);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 5L);
    }
}

