/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.effects;

import java.time.Instant;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.effects.Effect;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Stun
extends Effect {
    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Stun(), p);
    }

    public static void stunEntity(final LivingEntity entity, int duration) {
        entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, duration, 255, true, false));
        Stun.emitParticles(entity);
        PersistentDataUtility.store((Entity)entity, "stun", Instant.now().plusMillis((long)duration * 50L).toString());
        entity.setAI(false);
        new BukkitRunnable(){

            public void run() {
                entity.setAI(true);
                this.cancel();
                DebugUtility.consoleMessage("Stun", 4);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), (long)duration, 1L);
    }

    public static boolean checkStun(LivingEntity entity) {
        if (entity.isDead()) {
            return false;
        }
        String stun_end = PersistentDataUtility.readString((Entity)entity, "stun", Instant.ofEpochMilli(0L).toString());
        return Instant.parse(stun_end).isAfter(Instant.now());
    }

    @EventHandler
    public static void onDamageWhileStunned(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity;
        if (!Stun.checkStun(l)) {
            return;
        }
        e.setCancelled(true);
    }

    public static void emitParticles(final LivingEntity l) {
        new BukkitRunnable(){

            public void run() {
                if (!Stun.checkStun(l)) {
                    this.cancel();
                }
                l.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, l.getEyeLocation(), 5, 0.5, 0.5, 0.5, 0.1);
                DebugUtility.consoleMessage("Stun particles", 4);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 5L);
    }

    @EventHandler
    public void onStunnedTargetDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity;
        if (!Stun.checkStun(l)) {
            return;
        }
        e.setDamage(e.getDamage() * 2.0);
        e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 2.0f);
        e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.0f, 2.0f);
    }
}

