/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.effects;

import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.effects.Effect;
import me.ultra42.ultraskills.effects.Taunt;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class Charm
extends Effect {
    static HashMap<LivingEntity, HashMap<LivingEntity, Instant>> charm_targets = new HashMap();

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Charm(), p);
        Charm.createCharmTargetTable();
        Charm.reloadCharms();
    }

    public static void charmEntity(final Mob target_entity, int duration, final LivingEntity source) {
        if (target_entity == null) {
            return;
        }
        DebugUtility.consoleMessage(source.getName() + " charmed " + target_entity.getType(), 2);
        Charm.emitParticles((LivingEntity)target_entity);
        PersistentDataUtility.store((Entity)target_entity, "charm", Instant.now().plusMillis((long)duration * 50L).toString());
        PersistentDataUtility.store((Entity)target_entity, "charm-source", source.getUniqueId().toString());
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage("Charm", 4);
                if (target_entity.isDead()) {
                    this.cancel();
                } else if (!Charm.checkCharm((LivingEntity)target_entity)) {
                    this.cancel();
                } else if (Charm.getTargets(source).isEmpty()) {
                    DebugUtility.consoleMessage(source.getName() + " has no targets for charmed " + target_entity.getType(), 4);
                    target_entity.setTarget(null);
                } else {
                    DebugUtility.consoleMessage(source.getName() + "'s charmed " + target_entity.getType() + " does not have any valid targets.", 4);
                    target_entity.setTarget(Charm.findNearestTargetEntity(target_entity, source));
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
    }

    public static boolean checkCharm(LivingEntity entity) {
        if (entity.isDead()) {
            return false;
        }
        String charm_end = PersistentDataUtility.readString((Entity)entity, "charm", Instant.ofEpochMilli(0L).toString());
        return Instant.parse(charm_end).isAfter(Instant.now());
    }

    public static LivingEntity findNearestTargetEntity(Mob mob, LivingEntity source) {
        if (!charm_targets.containsKey(source)) {
            return null;
        }
        LivingEntity nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (Entity entity : mob.getNearbyEntities(33.0, 21.0, 33.0)) {
            double distance;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity l = (LivingEntity)entity;
            if (!charm_targets.get(source).containsKey(l) || Charm.checkCharm(l) || !((distance = entity.getLocation().distanceSquared(mob.getLocation())) < minDistance)) continue;
            minDistance = distance;
            nearest = (LivingEntity)entity;
        }
        return nearest;
    }

    public static void emitParticles(final LivingEntity l) {
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage("Charm particles", 4);
                if (!Charm.checkCharm(l)) {
                    this.cancel();
                }
                l.getWorld().spawnParticle(Particle.SPELL_WITCH, l.getEyeLocation(), 5, 0.5, 0.5, 0.5, 0.1);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 5L);
    }

    @EventHandler
    public static void setPlayerTargetDefendMelee(EntityDamageByEntityEvent e) {
        LivingEntity l;
        Entity entity;
        block3: {
            block2: {
                entity = e.getDamager();
                if (!(entity instanceof LivingEntity)) break block2;
                l = (LivingEntity)entity;
                entity = e.getEntity();
                if (entity instanceof Player) break block3;
            }
            return;
        }
        Player p = (Player)entity;
        Charm.addTarget((LivingEntity)p, l);
    }

    @EventHandler
    public static void setPlayerTargetDefendRanged(ProjectileHitEvent e) {
        LivingEntity l;
        ProjectileSource projectileSource;
        block3: {
            block2: {
                projectileSource = e.getEntity().getShooter();
                if (!(projectileSource instanceof LivingEntity)) break block2;
                l = (LivingEntity)projectileSource;
                projectileSource = e.getHitEntity();
                if (projectileSource instanceof Player) break block3;
            }
            return;
        }
        Player p = (Player)projectileSource;
        Charm.addTarget((LivingEntity)p, l);
    }

    @EventHandler
    public static void setPlayerTargetAttackMelee(EntityDamageByEntityEvent e) {
        LivingEntity l;
        Entity entity;
        block3: {
            block2: {
                entity = e.getEntity();
                if (!(entity instanceof LivingEntity)) break block2;
                l = (LivingEntity)entity;
                entity = e.getDamager();
                if (entity instanceof Player) break block3;
            }
            return;
        }
        Player p = (Player)entity;
        Charm.addTarget((LivingEntity)p, l);
    }

    @EventHandler
    public static void setPlayerTargetAttackRanged(ProjectileHitEvent e) {
        LivingEntity l;
        Entity entity;
        block3: {
            block2: {
                entity = e.getHitEntity();
                if (!(entity instanceof LivingEntity)) break block2;
                l = (LivingEntity)entity;
                entity = e.getEntity().getShooter();
                if (entity instanceof Player) break block3;
            }
            return;
        }
        Player p = (Player)entity;
        Charm.addTarget((LivingEntity)p, l);
    }

    @EventHandler
    public static void setPlayerTargetAggro(EntityTargetEvent e) {
        if (!e.getReason().equals((Object)EntityTargetEvent.TargetReason.CLOSEST_PLAYER) && !e.getReason().equals((Object)EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET)) {
            return;
        }
        Entity entity = e.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof Mob)) {
            return;
        }
        Mob m = (Mob)entity2;
        if (!charm_targets.containsKey(p)) {
            return;
        }
        Charm.addTarget((LivingEntity)p, (LivingEntity)m);
    }

    public static boolean addTarget(LivingEntity source, LivingEntity target) {
        if (Objects.equals(Charm.getCharmer(target), source)) {
            return false;
        }
        boolean already_targeted = false;
        if (charm_targets.get(source).containsKey(target)) {
            already_targeted = true;
            DebugUtility.consoleMessage("[Charm] Refreshing " + target.getType() + " to " + source.getName() + "'s targets.", 4);
        } else {
            DebugUtility.consoleMessage("[Charm] Adding " + target.getType() + " to " + source.getName() + "'s targets.", 3);
        }
        charm_targets.get(source).put(target, Instant.now());
        return already_targeted;
    }

    @EventHandler
    public static void onTargetCharmer(EntityTargetEvent e) {
        LivingEntity l;
        Entity entity;
        block6: {
            block5: {
                entity = e.getEntity();
                if (!(entity instanceof LivingEntity)) break block5;
                l = (LivingEntity)entity;
                entity = e.getTarget();
                if (entity instanceof Player) break block6;
            }
            return;
        }
        Player p = (Player)entity;
        if (!Charm.checkCharm(l)) {
            return;
        }
        UUID id = UUID.fromString(PersistentDataUtility.readString((Entity)l, "charm-source", ""));
        if (Objects.equals(p.getWorld().getEntity(id), p)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public static void onCharmAttack(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob receiver = (Mob)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Mob)) {
            return;
        }
        Mob attacker = (Mob)entity2;
        if (!Charm.checkCharm((LivingEntity)attacker)) {
            return;
        }
        Taunt.tauntEntity(receiver, 4, (LivingEntity)attacker);
    }

    public static void createCharmTargetTable() {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            charm_targets.put((LivingEntity)p, new HashMap());
        }
    }

    @EventHandler
    public static void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!charm_targets.containsKey(p)) {
            charm_targets.put((LivingEntity)p, new HashMap());
        }
    }

    public static HashMap<LivingEntity, Instant> getTargets(LivingEntity source) {
        if (!charm_targets.containsKey(source)) {
            charm_targets.put(source, new HashMap());
        }
        return charm_targets.get(source);
    }

    public static LivingEntity getCharmer(LivingEntity charmed_target) {
        String id_string = PersistentDataUtility.readString((Entity)charmed_target, "charm-source", "");
        if (Objects.equals(id_string, "")) {
            return null;
        }
        UUID id = UUID.fromString(id_string);
        Entity entity = charmed_target.getWorld().getEntity(id);
        if (entity instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity;
            return l;
        }
        return null;
    }

    public static void reloadCharms() {
        for (World world : Bukkit.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Mob)) continue;
                final Mob target_entity = (Mob)entity;
                DebugUtility.consoleMessage(" [Charm] Checking if " + target_entity.getType() + " was charmed before server stop/reload.", 5);
                if (!Charm.checkCharm((LivingEntity)target_entity)) continue;
                final LivingEntity charmer = Charm.getCharmer((LivingEntity)target_entity);
                String name = "";
                if (charmer instanceof Player) {
                    name = charmer.getName();
                } else if (charmer != null && charmer.customName() != null) {
                    name = Objects.requireNonNull(charmer.customName()).toString();
                } else if (charmer != null) {
                    name = charmer.getType().toString();
                }
                DebugUtility.consoleMessage(" [Charm] " + name + "'s charm reapplied to " + target_entity.getType(), 4);
                Charm.emitParticles((LivingEntity)target_entity);
                new BukkitRunnable(){

                    public void run() {
                        DebugUtility.consoleMessage("Charm", 4);
                        if (target_entity.isDead()) {
                            this.cancel();
                        } else if (!Charm.checkCharm((LivingEntity)target_entity)) {
                            this.cancel();
                        } else if (Charm.getTargets(charmer).isEmpty()) {
                            DebugUtility.consoleMessage(charmer.getName() + " has no targets for charmed " + target_entity.getType(), 4);
                            target_entity.setTarget(null);
                        } else {
                            DebugUtility.consoleMessage(charmer.getName() + "'s charmed " + target_entity.getType() + " does not have any valid targets.", 4);
                            target_entity.setTarget(Charm.findNearestTargetEntity(target_entity, charmer));
                        }
                    }
                }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
            }
        }
    }
}

