/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.effects;

import java.util.EnumSet;
import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.effects.Effect;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Bleed
extends Effect {
    public static Set<EntityType> noBloodMobs = EnumSet.of(EntityType.SKELETON, EntityType.WITHER_SKELETON, EntityType.WITHER, EntityType.SKELETON_HORSE, EntityType.STRAY);

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Bleed(), p);
    }

    public static void bleedEntity(final LivingEntity entity, int strength) {
        if (noBloodMobs.contains(entity.getType())) {
            return;
        }
        if (Bleed.getBleedStacks(entity) <= 0) {
            new BukkitRunnable(){

                public void run() {
                    if (Bleed.getBleedStacks(entity) <= 0 || entity.isDead()) {
                        Bleed.setBleedStacks(entity, 0);
                        this.cancel();
                    } else {
                        int bleed_stacks = Bleed.getBleedStacks(entity);
                        DebugUtility.consoleMessage("Bleed x" + bleed_stacks + " on " + entity.getType(), 4);
                        entity.damage(1.0 * (double)bleed_stacks);
                        Bleed.emitParticles(entity, bleed_stacks);
                        Bleed.setBleedStacks(entity, bleed_stacks - 1);
                    }
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 20L);
        }
        Bleed.addBleedStacks(entity, strength);
    }

    public static void setBleedStacks(LivingEntity entity, int i) {
        PersistentDataUtility.store((Entity)entity, "bleedStacks", i);
    }

    public static void addBleedStacks(LivingEntity entity, int i) {
        int current_stacks = PersistentDataUtility.readInt((Entity)entity, "bleedStacks");
        PersistentDataUtility.store((Entity)entity, "bleedStacks", current_stacks + i);
    }

    public static int getBleedStacks(LivingEntity entity) {
        return PersistentDataUtility.readInt((Entity)entity, "bleedStacks", 0);
    }

    public static void emitParticles(LivingEntity l, int multiplier) {
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.RED, 1.0f);
        l.getWorld().spawnParticle(Particle.REDSTONE, l.getEyeLocation().subtract(0.0, 0.5, 0.0), 5 * multiplier, 0.5, 0.5, 0.5, 0.1, (Object)dustOptions);
    }
}

