/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Trinkets;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class TrickOrTreat
extends Talent {
    private static String name = "TrickOrTreat";
    private static String description = "While wearing a carved pumpkin, killing things drops sweets.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 10;
    private static Material icon = Material.CARVED_PUMPKIN;
    private static int slot = 10;
    public static Set<Material> sweets = EnumSet.of(Material.COOKIE, new Material[]{Material.GOLDEN_CARROT, Material.HONEY_BOTTLE, Material.PUMPKIN_PIE, Material.CAKE, Material.SWEET_BERRIES, Material.GLOW_BERRIES});
    List<Material> treats = sweets.stream().toList();

    public TrickOrTreat() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new TrickOrTreat(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void entityDeathEvent(EntityDeathEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntity().getKiller() == null || e.getEntity().getKiller().getType() != EntityType.PLAYER) {
            return;
        }
        Player p = e.getEntity().getKiller();
        if (e.getEntity().getLastDamageCause() == null || Objects.requireNonNull(e.getEntity().getLastDamageCause()).getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        if (p.getInventory().getHelmet() == null || !p.getInventory().getHelmet().getType().equals((Object)Material.CARVED_PUMPKIN)) {
            return;
        }
        if (!TrickOrTreat.hasAbility(p)) {
            return;
        }
        Trinkets.giveXP(p, tree, 100, "TRICK-OR-TREAT");
        double roll = Math.random();
        if (roll >= 0.2) {
            Random randomizer = new Random();
            Material treat_material = this.treats.get(randomizer.nextInt(this.treats.size()));
            ItemStack treat = new ItemStack(treat_material, 1);
            e.getDrops().add(treat);
        } else {
            e.getEntity().getLocation().createExplosion(1.0f, false, false);
        }
    }
}

