/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Trinkets;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class TimeManagement
extends Talent {
    private static String name = "TimeManagement";
    private static String description = "Right click with a clock to move time. Left click to toggle between forwards and backwards.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 48;
    private static Material icon = Material.CLOCK;
    private static int slot = 48;

    public TimeManagement() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new TimeManagement(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void playerLeftClickClock(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!TimeManagement.hasAbility(p)) {
            return;
        }
        if (!p.getInventory().getItemInMainHand().getType().equals((Object)Material.CLOCK)) {
            return;
        }
        if (!e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            return;
        }
        e.setCancelled(true);
        if (PersistentDataUtility.readString((Entity)p, name, "false").equals("false")) {
            PersistentDataUtility.store(p, name, "true");
            p.playSound(p.getLocation(), Sound.BLOCK_END_PORTAL_FRAME_FILL, 1.0f, 0.5f);
        } else {
            PersistentDataUtility.store(p, name, "false");
            p.playSound(p.getLocation(), Sound.BLOCK_END_PORTAL_FRAME_FILL, 1.0f, 1.5f);
        }
    }

    @EventHandler
    public void playerRightClickClock(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!TimeManagement.hasAbility(p)) {
            return;
        }
        if (!p.getInventory().getItemInMainHand().getType().equals((Object)Material.CLOCK)) {
            return;
        }
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        e.setCancelled(true);
        World w = p.getWorld();
        int trinkets_lvl = Trinkets.getLevel(p, tree);
        if (trinkets_lvl < 20) {
            trinkets_lvl = 1;
        }
        if (e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            if (PersistentDataUtility.readString((Entity)p, name, "false").equals("false")) {
                this.advanceTime(w, 20L * (long)(trinkets_lvl - 19));
                p.playSound(p.getLocation(), Sound.ITEM_LODESTONE_COMPASS_LOCK, 0.4f, 1.5f);
            } else {
                this.advanceTime(w, -20L * (long)(trinkets_lvl - 19));
                p.playSound(p.getLocation(), Sound.ITEM_LODESTONE_COMPASS_LOCK, 0.4f, 0.5f);
            }
            Trinkets.giveXP(p, tree, 100, "TIME-MANAGEMENT");
        }
    }

    public void advanceTime(final World w, final long ticks) {
        final int[] count = new int[]{5};
        new BukkitRunnable(){

            public void run() {
                if (count[0] == 0) {
                    this.cancel();
                }
                count[0] = count[0] - 1;
                long currentTime = w.getTime();
                w.setTime(currentTime + ticks / 5L);
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }
}

