/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Trinkets;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ThroughTheLookingGlass
extends Talent {
    private static String name = "ThroughTheLookingGlass";
    private static String description = "When looking through a spyglass, jump to teleport to where you're aiming at.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 42;
    private static Material icon = Material.SPYGLASS;
    private static int slot = 42;

    public ThroughTheLookingGlass() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new ThroughTheLookingGlass(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public boolean isPlayerLookingGlass(Player p) {
        return p.getActiveItem().getType().equals((Object)Material.SPYGLASS);
    }

    @EventHandler
    public void PlayerJump(PlayerJumpEvent e) {
        Player p = e.getPlayer();
        if (!this.isPlayerLookingGlass(p)) {
            return;
        }
        if (!ThroughTheLookingGlass.hasAbility(p)) {
            return;
        }
        RayTraceResult result = p.rayTraceBlocks(200.0);
        if (result == null || result.getHitBlock() == null) {
            e.setCancelled(true);
            p.playSound(p.getLocation(), Sound.ITEM_SPYGLASS_USE, 1.0f, 0.5f);
            return;
        }
        Vector direction = p.getLocation().getDirection();
        Block target_block = result.getHitBlock();
        BlockFace face = result.getHitBlockFace();
        assert (face != null);
        Block teleport_spot = target_block.getRelative(face);
        Location teleport_loc = teleport_spot.getLocation().setDirection(direction);
        p.teleport(teleport_loc);
        p.playSound(p.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 0.5f);
        p.playSound(p.getLocation(), Sound.ENTITY_MOOSHROOM_CONVERT, 1.0f, 0.8f);
        Trinkets.giveXP(p, tree, (int)(direction.length() * 10.0), "THROUGH-LOOKING-GLASS");
    }
}

