/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.effects.Bleed;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Slice
extends Talent {
    private static String name = "Slice";
    private static String description = "Attacking things with shears applies two stacks of bleeding.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 14;
    private static Material icon = Material.SHEARS;
    private static int slot = 14;

    public Slice() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Slice(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity2;
        if (e.isCancelled()) {
            return;
        }
        if (!Slice.hasAbility(p)) {
            return;
        }
        if (!p.getInventory().getItemInMainHand().getType().equals((Object)Material.SHEARS)) {
            return;
        }
        Bleed.bleedEntity(l, 2);
        final int[] count = new int[]{2};
        new BukkitRunnable(){

            public void run() {
                if (count[0] <= 0) {
                    this.cancel();
                } else {
                    p.playSound(p.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
                    count[0] = count[0] - 1;
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 3L);
    }
}

