/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Trinkets;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class NightVision
extends Talent {
    private static String name = "NightVision";
    private static String description = "Receive night vision wile looking through a spyglass or wearing a carved pumpkin.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 4;
    private static Material icon = Material.SPYGLASS;
    private static int slot = 4;

    public NightVision() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new NightVision(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public boolean isPlayerLookingGlass(Player p) {
        return p.getActiveItem().getType().equals((Object)Material.SPYGLASS);
    }

    @EventHandler
    public void playerActivateSpyglass(PlayerInteractEvent e) {
        final Player p = e.getPlayer();
        if (!NightVision.hasAbility(p)) {
            return;
        }
        if (!p.getInventory().getItemInMainHand().getType().equals((Object)Material.SPYGLASS)) {
            return;
        }
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 600, 1));
        new BukkitRunnable(){

            public void run() {
                if (!NightVision.this.isPlayerLookingGlass(p)) {
                    p.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    this.cancel();
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
        Trinkets.giveXP(p, tree, 25, "NIGHT-VISION");
    }

    @EventHandler
    public void playerWearPumpkin(PlayerArmorChangeEvent e) {
        Player p = e.getPlayer();
        if (!e.getNewItem().getType().equals((Object)Material.CARVED_PUMPKIN) && !e.getOldItem().getType().equals((Object)Material.CARVED_PUMPKIN)) {
            return;
        }
        if (!NightVision.hasAbility(p)) {
            return;
        }
        if (e.getNewItem().getType().equals((Object)Material.CARVED_PUMPKIN)) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 1));
            Trinkets.giveXP(p, tree, 25, "NIGHT-VISION");
        } else if (e.getOldItem().getType().equals((Object)Material.CARVED_PUMPKIN)) {
            p.removePotionEffect(PotionEffectType.NIGHT_VISION);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!NightVision.hasAbility(p)) {
            return;
        }
        if (p.getInventory().getHelmet() == null || !p.getInventory().getHelmet().getType().equals((Object)Material.CARVED_PUMPKIN)) {
            return;
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 1));
    }
}

