/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.effects.Charm;
import me.ultra42.ultraskills.skillgroups.Trinkets;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Vex;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Mutiny
extends Talent {
    private static String name = "Mutiny";
    private static String description = "Instead of receiving the Bad Omen effect, become a captain. Summons illagers to follow and fight for you. Recieve better units as your party grows, with a cooldown for each unit and. (Pillager-> Vindicator-> Illusioner-> Evoker-> Ravager) This party disbands if you leave or if all units die.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 32;
    private static Material icon = Material.SKULL_BANNER_PATTERN;
    private static int slot = 32;
    private static int cost_pillager = 15;
    private static int cost_vindicator = 30;
    private static int cost_illusioner = 60;
    private static int cost_evoker = 120;
    private static int cost_ravager = 240;

    public Mutiny() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Mutiny(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBadOmen(EntityPotionEffectEvent event) {
        if (!event.getModifiedType().equals((Object)PotionEffectType.BAD_OMEN)) {
            return;
        }
        if (!event.getEntityType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        event.setCancelled(true);
        final Player p = (Player)event.getEntity();
        p.sendMessage("Bad Omen avoided.");
        if (Mutiny.isCaptain(p)) {
            return;
        }
        p.sendMessage("You are the captain now.");
        Trinkets.giveXP(p, tree, 5000, "MUTINY");
        PersistentDataUtility.store((Entity)p, name, 0);
        DebugUtility.consoleMessage(p.getName() + " is staging a mutiny!", 2);
        new BukkitRunnable(){

            public void run() {
                if (!p.isOnline()) {
                    this.cancel();
                    DebugUtility.consoleMessage(p.getName() + "'s mutiny has ended in their absence.", 3);
                } else if (p.isDead()) {
                    this.cancel();
                    DebugUtility.consoleMessage(p.getName() + "'s mutiny has ended upon their death.", 3);
                } else {
                    int stacks = PersistentDataUtility.readInt((Entity)p, name, 0);
                    DebugUtility.consoleMessage(p.getName() + " is staging a mutiny. " + stacks / Mutiny.getCost(Mutiny.getNextBestIllager(p)) + "%", 4);
                    PersistentDataUtility.store((Entity)p, name, stacks + 1);
                    Mutiny.illagerSpawnCheck(p);
                    Mutiny.teleportParty(p);
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 20L);
    }

    public static boolean isCaptain(Player p) {
        return !Mutiny.getIllagers(p).isEmpty();
    }

    public static Mob getIllager(Player p, EntityType type) {
        String id = PersistentDataUtility.readString((Entity)p, name + type.toString(), "");
        if (id.equals("")) {
            return null;
        }
        Entity entity = Bukkit.getServer().getEntity(UUID.fromString(id));
        if (entity == null || entity.isDead() || !(entity instanceof Mob)) {
            return null;
        }
        Mob mob = (Mob)entity;
        if (!mob.getType().equals((Object)type)) {
            return null;
        }
        return mob;
    }

    public static List<Mob> getIllagers(Player p) {
        Mob ravager;
        Mob evoker;
        Mob illusioner;
        Mob vindicator;
        ArrayList<Mob> illagers = new ArrayList<Mob>();
        Mob pillager = Mutiny.getIllager(p, EntityType.PILLAGER);
        if (pillager != null) {
            illagers.add(pillager);
        }
        if ((vindicator = Mutiny.getIllager(p, EntityType.VINDICATOR)) != null) {
            illagers.add(vindicator);
        }
        if ((illusioner = Mutiny.getIllager(p, EntityType.ILLUSIONER)) != null) {
            illagers.add(illusioner);
        }
        if ((evoker = Mutiny.getIllager(p, EntityType.EVOKER)) != null) {
            illagers.add(evoker);
        }
        if ((ravager = Mutiny.getIllager(p, EntityType.RAVAGER)) != null) {
            illagers.add(ravager);
        }
        return illagers;
    }

    public static EntityType getNextBestIllager(Player p) {
        if (Mutiny.getIllager(p, EntityType.PILLAGER) == null) {
            return EntityType.PILLAGER;
        }
        if (Mutiny.getIllager(p, EntityType.VINDICATOR) == null) {
            return EntityType.VINDICATOR;
        }
        if (Mutiny.getIllager(p, EntityType.ILLUSIONER) == null) {
            return EntityType.ILLUSIONER;
        }
        if (Mutiny.getIllager(p, EntityType.EVOKER) == null) {
            return EntityType.EVOKER;
        }
        if (Mutiny.getIllager(p, EntityType.RAVAGER) == null) {
            return EntityType.RAVAGER;
        }
        return null;
    }

    public static int getCost(EntityType type) {
        if (type == null) {
            return Integer.MAX_VALUE;
        }
        if (type.equals((Object)EntityType.PILLAGER)) {
            return cost_pillager;
        }
        if (type.equals((Object)EntityType.VINDICATOR)) {
            return cost_vindicator;
        }
        if (type.equals((Object)EntityType.ILLUSIONER)) {
            return cost_illusioner;
        }
        if (type.equals((Object)EntityType.EVOKER)) {
            return cost_evoker;
        }
        if (type.equals((Object)EntityType.RAVAGER)) {
            return cost_ravager;
        }
        return Integer.MAX_VALUE;
    }

    public static void illagerSpawnCheck(Player p) {
        int stacks = PersistentDataUtility.readInt((Entity)p, name, 0);
        EntityType next_type = Mutiny.getNextBestIllager(p);
        if (next_type == null) {
            if (stacks > 30) {
                Mutiny.healParty(p);
                PersistentDataUtility.store((Entity)p, name, stacks - 30);
            }
            return;
        }
        int cost = Mutiny.getCost(next_type);
        if (stacks < cost) {
            DebugUtility.consoleMessage(p.getName() + "'s " + name + " summon charging up... " + 100 * stacks / cost + "%", 4);
            return;
        }
        Location loc = p.getLocation();
        Mob ravager = Mutiny.getIllager(p, EntityType.RAVAGER);
        if (ravager != null) {
            loc = ravager.getLocation();
        }
        Mob summon = (Mob)p.getWorld().spawnEntity(loc, next_type);
        p.playSound(p.getLocation(), Sound.ENTITY_EVOKER_PREPARE_SUMMON, 1.0f, 0.5f);
        if (ravager != null) {
            ravager.addPassenger((Entity)summon);
        }
        DebugUtility.consoleMessage(p.getName() + "'s " + name + " summoned " + next_type, 2);
        String id = summon.getUniqueId().toString();
        PersistentDataUtility.store(p, name + next_type, id);
        Charm.charmEntity(summon, Integer.MAX_VALUE, (LivingEntity)p);
        PersistentDataUtility.store((Entity)p, name, stacks - cost);
    }

    public static void healParty(Player p) {
        for (Mob mob : Mutiny.getIllagers(p)) {
            mob.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, 1));
            mob.getWorld().playSound(mob.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 2.5f);
            mob.getWorld().spawnParticle(Particle.HEART, mob.getEyeLocation(), 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public static void teleportParty(Player p) {
        for (Mob mob : Mutiny.getIllagers(p)) {
            if (!(mob.getLocation().distance(p.getLocation()) > 40.0)) continue;
            mob.teleport((Entity)p);
        }
    }

    @EventHandler
    public void onCharmedVexSpawn(EntitySpawnEvent e) {
        if (!e.getEntity().getType().equals((Object)EntityType.VEX)) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Vex)) {
            return;
        }
        Vex vex = (Vex)entity;
        Mob summoner = vex.getSummoner();
        if (summoner == null || !Charm.checkCharm((LivingEntity)summoner)) {
            return;
        }
        Charm.charmEntity((Mob)vex, Integer.MAX_VALUE, Charm.getCharmer((LivingEntity)summoner));
    }

    @EventHandler
    public void onRavagerRightClick(PlayerInteractEntityEvent event) {
        Ravager ravager;
        Player p = event.getPlayer();
        if (!Mutiny.hasAbility(p)) {
            return;
        }
        if (event.getRightClicked().getType() == EntityType.RAVAGER && Charm.checkCharm((LivingEntity)(ravager = (Ravager)event.getRightClicked()))) {
            ravager.addPassenger((Entity)p);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!Mutiny.hasAbility(p)) {
            return;
        }
        if (!Mutiny.isCaptain(p)) {
            return;
        }
        p.sendMessage("Your illager party disbanded while you were away.");
        PersistentDataUtility.store((Entity)p, name, 0);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (!Mutiny.hasAbility(p)) {
            return;
        }
        if (!Mutiny.isCaptain(p)) {
            return;
        }
        for (Mob mob : Mutiny.getIllagers(p)) {
            mob.clearLootTable();
            mob.remove();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getPlayer();
        if (!Mutiny.hasAbility(p)) {
            return;
        }
        if (!Mutiny.isCaptain(p)) {
            return;
        }
        for (Mob mob : Mutiny.getIllagers(p)) {
            mob.clearLootTable();
            mob.remove();
        }
        p.sendMessage("Your illager party disbanded upon your death.");
        PersistentDataUtility.store((Entity)p, name, 0);
    }
}

