/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Trinkets;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GrapplingHook
extends Talent {
    private static String name = "GrapplingHook";
    private static String description = "Pull yourself up by your bootstraps.";
    private static String tree = "Trinkets";
    private static int requiredLevel = 24;
    private static Material icon = Material.FISHING_ROD;
    private static int slot = 24;

    public GrapplingHook() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new GrapplingHook(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void grappleEvent(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        final Player p = e.getPlayer();
        if (!GrapplingHook.hasAbility(p) || !p.getInventory().getItemInMainHand().getType().equals((Object)Material.FISHING_ROD)) {
            return;
        }
        p.setVelocity(new Vector(0, 0, 0));
        new BukkitRunnable(){

            public void run() {
                boolean found = false;
                for (Entity entity : p.getWorld().getNearbyEntities(p.getLocation(), 100.0, 100.0, 100.0)) {
                    FishHook hook;
                    if (!(entity instanceof FishHook) || !(hook = (FishHook)entity).getShooter().equals(p)) continue;
                    found = true;
                    if (hook.isDead()) {
                        p.setGravity(true);
                        this.cancel();
                        continue;
                    }
                    if (p.isSneaking()) {
                        hook.remove();
                        this.cancel();
                        p.setGravity(true);
                        p.setFallDistance(0.0f);
                        continue;
                    }
                    if (hook.getHookedEntity() != null && hook.getHookedEntity() != p) {
                        Entity target = hook.getHookedEntity();
                        Vector direction = target.getLocation().toVector().subtract(p.getLocation().toVector()).normalize();
                        p.setVelocity(direction.multiply(1.2));
                        target.setVelocity(direction.multiply(-1.2));
                        if (!(p.getLocation().distance(hook.getLocation()) <= 3.0)) continue;
                        p.setVelocity(direction.multiply(-0.2));
                        target.setVelocity(direction.multiply(0.2));
                        this.cancel();
                        hook.remove();
                        p.setGravity(true);
                        p.setFallDistance(0.0f);
                        continue;
                    }
                    if (hook.isOnGround()) {
                        hook.setGravity(false);
                        hook.setVelocity(new Vector(0, 0, 0));
                        GrapplingHook.this.updatePlayerVelocity(p, hook.getLocation());
                        GrapplingHook.this.drawline(p.getLocation(), hook.getLocation(), 2.0);
                        p.playSound(entity.getLocation(), Sound.ITEM_TRIDENT_HIT, 0.4f, 1.5f);
                        if (!(p.getLocation().distance(hook.getLocation()) <= 3.0)) continue;
                        this.cancel();
                        hook.remove();
                        p.setGravity(true);
                        p.setFallDistance(0.0f);
                        continue;
                    }
                    if (hook.getVelocity().getX() == 0.0 || hook.getVelocity().getY() == 0.0) {
                        hook.setGravity(false);
                        hook.setVelocity(new Vector(0.0, 0.03, 0.0));
                        GrapplingHook.this.updatePlayerVelocity(p, hook.getLocation());
                        GrapplingHook.this.drawline(p.getLocation(), hook.getLocation(), 2.0);
                        p.playSound(entity.getLocation(), Sound.ITEM_TRIDENT_HIT, 0.4f, 1.5f);
                        if (!(p.getLocation().distance(hook.getLocation()) <= 3.0)) continue;
                        this.cancel();
                        hook.remove();
                        p.setGravity(true);
                        p.setFallDistance(0.0f);
                        p.playSound(entity.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                        continue;
                    }
                    hook.setVelocity(hook.getVelocity().multiply(1.2));
                }
                if (!found) {
                    p.setGravity(true);
                    this.cancel();
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
        Trinkets.giveXP(p, tree, 50, "GRAPPLE");
    }

    private void updatePlayerVelocityNew(Player p, Location target) {
        double radius = p.getEyeLocation().distance(target);
        double x_diff = Math.abs(p.getLocation().getX() - target.getX());
        double z_diff = Math.abs(p.getLocation().getZ() - target.getZ());
        double lateral_radius = Math.sqrt(x_diff * x_diff + z_diff * z_diff);
        Vector difference = target.toVector().subtract(p.getEyeLocation().toVector());
        if (difference.length() > 10.0) {
            p.setVelocity(p.getVelocity().add(difference.normalize().multiply(0.2)));
        }
    }

    private void updatePlayerVelocity(Player p, Location target) {
        double radius = p.getEyeLocation().distance(target);
        double x_diff = Math.abs(p.getLocation().getX() - target.getX());
        double z_diff = Math.abs(p.getLocation().getZ() - target.getZ());
        double lateral_radius = Math.sqrt(x_diff * x_diff + z_diff * z_diff);
        Vector difference = target.toVector().subtract(p.getEyeLocation().toVector());
        p.setVelocity(difference.normalize().multiply(1.2));
    }

    private void drawline(Location point1, Location point2, double space) {
        World world = point1.getWorld();
        double distance = point1.distance(point2);
        Vector p1 = point1.toVector();
        Vector p2 = point2.toVector();
        Vector vector = p2.clone().subtract(p1).normalize().multiply(space);
        for (double covered = 0.0; covered < distance; covered += space) {
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.YELLOW, 1.0f);
            world.spawnParticle(Particle.REDSTONE, p1.getX(), p1.getY(), p1.getZ(), 1, (Object)dustOptions);
            p1.add(vector);
        }
    }

    private Vector pullToTarget(Player p, Location center) {
        Vector direction = center.toVector().subtract(p.getLocation().toVector()).normalize();
        return direction;
    }

    private Vector calculateCentripetal(Player p, Location center) {
        Vector v = p.getVelocity();
        double r = center.distance(p.getLocation());
        Vector u_r = center.toVector().subtract(p.getLocation().toVector());
        Vector a_c = v.multiply(v).multiply(1.0 / r).multiply(u_r);
        return a_c;
    }
}

