/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.trinkets;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Bard
extends Talent {
    private static String name = "Bard";
    private static String description = "(WIP - Coming Soon) Playing different music disks .";
    private static String tree = "Trinkets";
    private static int requiredLevel = 20;
    private static Material icon = Material.JUKEBOX;
    private static int slot = 20;

    public Bard() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Bard(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onRecordPlay(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        final Block block = event.getClickedBlock();
        Material disc = player.getInventory().getItemInMainHand().getType();
        if (!disc.name().startsWith("MUSIC_DISC_") || block.getType() != Material.JUKEBOX) {
            return;
        }
        AbilityManager.putCooldown(player, name, 1000);
        final PotionEffect effect = new PotionEffect(Bard.getEffect(disc), 100, 1);
        new BukkitRunnable(){

            public void run() {
                Jukebox j;
                if (block instanceof Jukebox && (j = (Jukebox)block).isPlaying()) {
                    for (Entity e : block.getLocation().getNearbyEntities(30.0, 30.0, 30.0)) {
                        if (!(e instanceof Player)) continue;
                        Player p = (Player)e;
                        p.addPotionEffect(effect);
                    }
                } else {
                    this.cancel();
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 10L, 80L);
    }

    public static PotionEffectType getEffect(Material disc) {
        return switch (disc) {
            case Material.MUSIC_DISC_5 -> PotionEffectType.DARKNESS;
            case Material.MUSIC_DISC_11 -> PotionEffectType.BLINDNESS;
            case Material.MUSIC_DISC_13 -> PotionEffectType.UNLUCK;
            case Material.MUSIC_DISC_BLOCKS -> PotionEffectType.FAST_DIGGING;
            case Material.MUSIC_DISC_CAT -> PotionEffectType.REGENERATION;
            case Material.MUSIC_DISC_CHIRP -> PotionEffectType.NIGHT_VISION;
            case Material.MUSIC_DISC_FAR -> PotionEffectType.SPEED;
            case Material.MUSIC_DISC_MALL -> PotionEffectType.WATER_BREATHING;
            case Material.MUSIC_DISC_MELLOHI -> PotionEffectType.INVISIBILITY;
            case Material.MUSIC_DISC_OTHERSIDE -> PotionEffectType.JUMP;
            case Material.MUSIC_DISC_PIGSTEP -> PotionEffectType.FIRE_RESISTANCE;
            case Material.MUSIC_DISC_STAL -> PotionEffectType.HEALTH_BOOST;
            case Material.MUSIC_DISC_STRAD -> PotionEffectType.INCREASE_DAMAGE;
            case Material.MUSIC_DISC_WAIT -> PotionEffectType.LUCK;
            case Material.MUSIC_DISC_WARD -> PotionEffectType.DAMAGE_RESISTANCE;
            default -> PotionEffectType.SLOW;
        };
    }
}

