/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.ranged;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class Pinup
extends Talent {
    private static String name = "Pinup";
    private static String description = "Fired projectiles lift targets struck with them into the air.";
    private static String tree = "Ranged";
    private static int requiredLevel = 18;
    private static Material icon = Material.FEATHER;
    private static int slot = 18;

    public Pinup() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Pinup(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        ProjectileSource shooter;
        if (event.getEntity().getType() == EntityType.ARROW && (shooter = event.getEntity().getShooter()) instanceof Player) {
            Player player = (Player)shooter;
            Entity entity = event.getHitEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (Pinup.hasAbility(player)) {
                    event.getEntity().setPersistent(true);
                    target.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 200, 1));
                    player.playSound(target.getLocation(), Sound.ENTITY_ARROW_HIT, 1.0f, 1.0f);
                }
            }
        }
    }
}

