/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.ranged;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Homing
extends Talent {
    private static String name = "Homing";
    private static String description = "Arrows seek nearby targets.";
    private static String tree = "Ranged";
    private static int requiredLevel = 32;
    private static Material icon = Material.COMPASS;
    private static int slot = 32;

    public Homing() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Homing(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        final Player p = (Player)livingEntity;
        if (!p.getInventory().getItemInMainHand().getType().equals((Object)Material.BOW) && !p.getInventory().getItemInMainHand().getType().equals((Object)Material.CROSSBOW)) {
            return;
        }
        final Entity arrow = event.getProjectile();
        if (AbilityManager.getCooldown(p, name).isBefore(Instant.now().minusMillis(15000L))) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "homing-target");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"");
        }
        String targetIdString = (String)p.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        Entity target = null;
        if (!targetIdString.equals("")) {
            UUID targetId = UUID.fromString(targetIdString);
            target = p.getWorld().getEntity(targetId);
        }
        if (Homing.hasAbility(p) && target != null) {
            final Entity finalTarget = target;
            new BukkitRunnable(){

                public void run() {
                    if (arrow.isOnGround() || arrow.isDead()) {
                        this.cancel();
                    } else if (finalTarget instanceof LivingEntity && !finalTarget.isDead() && finalTarget != p) {
                        Vector arrowVector = arrow.getVelocity();
                        Vector targetVector = ((LivingEntity)finalTarget).getEyeLocation().toVector().subtract(arrow.getLocation().toVector()).normalize();
                        Vector direction = Homing.this.averageVector(arrowVector, targetVector);
                        arrow.setVelocity(direction);
                    }
                    DebugUtility.consoleMessage(p.getName() + "'s " + name + " projectile in air", 4);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
        } else if (Homing.hasAbility(p)) {
            new BukkitRunnable(){

                public void run() {
                    if (arrow.isOnGround() || arrow.isDead()) {
                        this.cancel();
                    } else {
                        List nearest = arrow.getNearbyEntities(5.0, 5.0, 5.0);
                        for (Entity target : nearest) {
                            if (!p.hasLineOfSight(target) || !(target instanceof LivingEntity) || target.isDead() || target == p) continue;
                            Vector direction = target.getLocation().toVector().subtract(arrow.getLocation().toVector()).normalize();
                            arrow.setVelocity(direction);
                        }
                    }
                    DebugUtility.consoleMessage(p.getName() + "'s " + name + " projectile in air", 4);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
        }
        AbilityManager.putCooldown(p, name, 0);
    }

    @EventHandler
    public void onDrawBow(PlayerInteractEvent e) {
        final Player p = e.getPlayer();
        if (!(e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || this.isPlayerDrawingBow(p))) {
            return;
        }
        final NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "homing-target");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"");
        }
        String targetId = (String)p.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        if (Homing.hasAbility(p) && this.isPlayerHoldingBow(p)) {
            new BukkitRunnable(){

                public void run() {
                    Entity tar = p.getTargetEntity(100);
                    if (Homing.this.isPlayerDrawingBow(p) && tar instanceof LivingEntity) {
                        LivingEntity liveTar = (LivingEntity)tar;
                        String pastTargetIdString = (String)p.getPersistentDataContainer().get(key, PersistentDataType.STRING);
                        UUID newTargetId = liveTar.getUniqueId();
                        assert (pastTargetIdString != null);
                        if (pastTargetIdString.equals("") || !UUID.fromString(pastTargetIdString).equals(newTargetId)) {
                            p.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)newTargetId.toString());
                            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 0.5f);
                            AbilityManager.putCooldown(p, name, 0);
                        }
                    } else if (!Homing.this.isPlayerDrawingBow(p)) {
                        this.cancel();
                    }
                    DebugUtility.consoleMessage(p.getName() + " searching for " + name + " targets...", 4);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 5L, 1L);
        }
    }

    public boolean isPlayerDrawingBow(Player p) {
        if (p.getActiveItem().getType().equals((Object)Material.BOW)) {
            return true;
        }
        return p.getActiveItem().getType().equals((Object)Material.CROSSBOW);
    }

    public boolean isPlayerHoldingBow(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack activeItem = inventory.getItemInMainHand();
        return activeItem != null && (activeItem.getType() == Material.BOW || activeItem.getType() == Material.CROSSBOW);
    }

    public Vector averageVector(Vector vec1, Vector vec2) {
        double x = (vec1.getX() + vec2.getX()) / 2.0;
        double y = (vec1.getY() + vec2.getY()) / 2.0;
        double z = (vec1.getZ() + vec2.getZ()) / 2.0;
        return new Vector(x, y, z);
    }
}

