/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.ranged;

import java.util.HashMap;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Heavy
extends Talent {
    private static String name = "Heavy";
    private static String description = "Minigun on bows.";
    private static String tree = "Ranged";
    private static int requiredLevel = 27;
    private static Material icon = Material.ANVIL;
    private static int slot = 27;

    public Heavy() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Heavy(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onDrawBow(PlayerInteractEvent e) {
        final Player p = e.getPlayer();
        if (!(e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || this.isPlayerDrawingBow(p))) {
            return;
        }
        final double arrowSpeed = 3.0;
        final int windup = 4;
        final String key = "heavy-stacks";
        PersistentDataUtility.store((Entity)p, key, 0);
        final int[] counter = new int[]{windup};
        if (Heavy.hasAbility(p) && this.isPlayerHoldingBow(p)) {
            new BukkitRunnable(){

                public void run() {
                    int stacks = PersistentDataUtility.readInt((Entity)p, key, 0);
                    HashMap arrowMap = p.getInventory().all(Material.ARROW);
                    int arrowCount = arrowMap.size();
                    if (arrowCount > 0) {
                        if (Heavy.this.isPlayerDrawingBow(p) && stacks >= counter[0]) {
                            Location playerLocation = p.getEyeLocation();
                            Vector playerDirection = playerLocation.getDirection();
                            Vector velocity = playerDirection.multiply(arrowSpeed);
                            p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.ARROW, 1)});
                            Arrow arrow = (Arrow)p.getWorld().spawn(playerLocation, Arrow.class);
                            arrow.setVelocity(velocity);
                            arrow.setShooter((ProjectileSource)p);
                            p.playSound(p.getLocation(), Sound.ENTITY_ARROW_SHOOT, 1.0f, 1.0f);
                            EntityShootBowEvent event = new EntityShootBowEvent((LivingEntity)p, p.getInventory().getItemInMainHand(), (Entity)arrow, 1.0f);
                            Bukkit.getServer().getPluginManager().callEvent((Event)event);
                            if (stacks < windup) {
                                PersistentDataUtility.store((Entity)p, key, ++stacks);
                                counter[0] = windup;
                            }
                        } else if (!Heavy.this.isPlayerDrawingBow(p)) {
                            this.cancel();
                        } else {
                            counter[0] = counter[0] - 1;
                        }
                    }
                    DebugUtility.consoleMessage(name, 4);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 10L, (long)windup + 2L - (long)PersistentDataUtility.readInt((Entity)p, key));
        }
    }

    public boolean isPlayerDrawingBow(Player p) {
        return p.getActiveItem().getType().equals((Object)Material.BOW);
    }

    public boolean isPlayerHoldingBow(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack activeItem = inventory.getItemInMainHand();
        return activeItem != null && activeItem.getType() == Material.BOW;
    }

    public Vector averageVector(Vector vec1, Vector vec2) {
        double x = (vec1.getX() + vec2.getX()) / 2.0;
        double y = (vec1.getY() + vec2.getY()) / 2.0;
        double z = (vec1.getZ() + vec2.getZ()) / 2.0;
        return new Vector(x, y, z);
    }
}

