/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.ranged;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.effects.Charm;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class Cupid
extends Talent {
    private static String name = "Cupid";
    private static String description = "Charm targets struck for 15 seconds.  Ranged modes: press the swap item button while holding a bow to cycle between your unlocked ranged modes. ";
    private static String tree = "Ranged";
    private static int requiredLevel = 24;
    private static Material icon = Material.ROSE_BUSH;
    private static int slot = 24;

    public Cupid() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Cupid(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(Event e, boolean isSecondary) {
        if (isSecondary && e instanceof PlayerInteractEvent) {
            PlayerInteractEvent e2 = (PlayerInteractEvent)e;
            Cupid.secondary(e2);
        } else if (e instanceof PlayerInteractEvent) {
            PlayerInteractEvent e1 = (PlayerInteractEvent)e;
            Cupid.primary(e1);
        } else if (e instanceof ProjectileLaunchEvent) {
            ProjectileLaunchEvent e3 = (ProjectileLaunchEvent)e;
            Cupid.onShoot(e3);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
    }

    public static void onShoot(final ProjectileLaunchEvent e) {
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player p = (Player)projectileSource;
        Projectile projectile = e.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        final Arrow a = (Arrow)projectile;
        PersistentDataUtility.store((Entity)a, name, 1);
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage(name);
                if (a.isDead()) {
                    this.cancel();
                } else {
                    e.getEntity().getWorld().spawnParticle(Particle.HEART, e.getEntity().getLocation(), 1, 0.5, 0.5, 0.5, 0.1);
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }

    @EventHandler
    public static void onCupidHit(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player p = (Player)projectileSource;
        Entity entity = event.getHitEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob m = (Mob)entity;
        if (PersistentDataUtility.readInt((Entity)event.getEntity(), name, 0) == 0) {
            return;
        }
        Charm.charmEntity(m, 1200, (LivingEntity)p);
    }
}

