/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.ranged;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Blink
extends Talent {
    private static String name = "Blink";
    private static String description = "Blink forward ten blocks by jumping while aiming a bow.";
    private static String tree = "Ranged";
    private static int requiredLevel = 38;
    private static Material icon = Material.ENDER_EYE;
    private static int slot = 38;
    int distance = 4;

    public Blink() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Blink(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public boolean isPlayerDrawingBow(Player p) {
        return p.getActiveItem().getType().equals((Object)Material.BOW);
    }

    public Vector averageVector(Vector vec1, Vector vec2) {
        double x = (vec1.getX() + vec2.getX()) / 2.0;
        double y = (vec1.getY() + vec2.getY()) / 2.0;
        double z = (vec1.getZ() + vec2.getZ()) / 2.0;
        return new Vector(x, y, z);
    }

    @EventHandler
    public void PlayerJump(PlayerJumpEvent e) {
        Player p = e.getPlayer();
        if (!Blink.hasAbility(p)) {
            return;
        }
        if (!p.isSneaking()) {
            return;
        }
        if (!this.isPlayerDrawingBow(p)) {
            return;
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 20, 1));
        p.playSound(p.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, 1.0f, 1.0f);
        this.teleportForward(p);
    }

    public void teleportForward(Player player) {
        Location playerLocation = player.getLocation();
        double yaw = Math.toRadians(playerLocation.getYaw());
        double pitch = Math.toRadians(playerLocation.getPitch());
        double xDirection = Math.cos(pitch) * Math.cos(yaw);
        double yDirection = Math.sin(pitch);
        double zDirection = Math.cos(pitch) * Math.sin(yaw);
        double targetX = playerLocation.getX() - zDirection * (double)this.distance;
        double targetY = playerLocation.getY() + yDirection * (double)this.distance;
        double targetZ = playerLocation.getZ() + xDirection * (double)this.distance;
        World world = player.getWorld();
        int highestSolidBlockY = world.getHighestBlockYAt((int)targetX, (int)targetZ);
        Block highestSolidBlock = world.getBlockAt((int)targetX, highestSolidBlockY, (int)targetZ);
        Location safeLocation = new Location(world, (double)highestSolidBlock.getX(), (double)(highestSolidBlock.getY() + 1), (double)highestSolidBlock.getZ());
        safeLocation.setYaw(playerLocation.getYaw());
        safeLocation.setPitch(playerLocation.getPitch());
        player.teleport(safeLocation);
    }
}

