/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.ArrayList;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class TunnelRat
extends Talent {
    private static String name = "TunnelRat";
    private static String description = "MINING MODE: Upon mining a block with a pickaxe from the side at eye level, breaks the block beneath it too. (Press the swap item button to change mining modes; default is F)";
    private static String tree = "Mining";
    private static int requiredLevel = 13;
    private static Material icon = Material.STONE_PICKAXE;
    private static int slot = 13;

    public TunnelRat() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new TunnelRat(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(BlockBreakEvent e, boolean isSecondary) {
        Block b = e.getBlock();
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        String face = PersistentDataUtility.readString((Entity)p, "mining_face", BlockFace.SELF.name());
        if (face.equals("DOWN") || face.equals("UP") || face.equals("SELF")) {
            return;
        }
        if (!TunnelRat.isEyeLevel(b, p)) {
            return;
        }
        Block below = TunnelRat.getBlockBeneath(b);
        ArrayList<ArrayList<Block>> blocks = new ArrayList<ArrayList<Block>>();
        if (below != null) {
            ArrayList<Block> lower = new ArrayList<Block>();
            lower.add(below);
            blocks.add(lower);
        }
        UltraBlock.breakBlocks(blocks, p);
    }

    public static Block getBlockBeneath(Block block) {
        if (block == null || block.getType().equals((Object)Material.VOID_AIR)) {
            return null;
        }
        return block.getRelative(BlockFace.DOWN);
    }

    public static boolean isEyeLevel(Block block, Player player) {
        int blockY;
        int playerY = player.getEyeLocation().getBlockY();
        return Math.abs(playerY - (blockY = block.getY())) <= 1;
    }
}

