/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.ubb.BlockChangeManager;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Reinvesting
extends Talent {
    private static String name = "Reinvesting";
    private static String description = "Breaking blocks of the same material as your pick repairs it.";
    private static String tree = "Mining";
    private static int requiredLevel = 4;
    private static Material icon = Material.RAW_GOLD;
    private static int slot = 4;
    public static Set<Material> ores = EnumSet.of(Material.COAL_ORE, new Material[]{Material.COPPER_ORE, Material.LAPIS_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.REDSTONE_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE});

    public Reinvesting() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Reinvesting(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material m = block.getType();
        if (Reinvesting.hasAbility(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL) && tool.getType().name().endsWith("_PICKAXE")) {
            if (tool.getType() == Material.WOODEN_PICKAXE || tool.getType() == Material.WOODEN_AXE) {
                // empty if block
            }
            if (tool.getType() == Material.STONE_PICKAXE && block.getType() == Material.STONE && !tool.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
                this.repair(tool, 4);
            }
            if (tool.getType() == Material.IRON_PICKAXE && block.getType() == Material.IRON_ORE && !tool.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
                this.repair(tool, 24);
            }
            if (tool.getType() == Material.GOLDEN_PICKAXE && block.getType() == Material.GOLD_ORE && !tool.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
                this.repair(tool, 48);
            }
            if (tool.getType() == Material.DIAMOND_PICKAXE && block.getType() == Material.DIAMOND_ORE && !tool.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
                this.repair(tool, 256);
            }
            if (tool.getType() == Material.NETHERITE_PICKAXE && block.getType() == Material.ANCIENT_DEBRIS && Objects.equals(BlockChangeManager.getMaker(block), "")) {
                this.repair(tool, 2048);
            }
        }
    }

    public void repair(ItemStack t, int amount) {
        ItemMeta im = t.getItemMeta();
        if (im instanceof Damageable) {
            Damageable dmg = (Damageable)im;
            if (dmg.hasDamage()) {
                dmg.setDamage(dmg.getDamage() - amount);
            }
            t.setItemMeta(im);
        }
    }

    public List<Block> getSurrounding(Location origin) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    Location loc = origin.clone().add((double)x, (double)y, (double)z);
                    Block block = loc.getBlock();
                    if (origin.equals((Object)loc) || block.getType() != origin.getBlock().getType()) continue;
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    public List<Block> getOres(Location origin) {
        ArrayList<Block> vein = new ArrayList<Block>();
        List<Block> next = this.getSurrounding(origin);
        while (!next.isEmpty()) {
            ArrayList<Block> nextNext = new ArrayList<Block>();
            for (Block ore : next) {
                if (vein.contains(ore)) continue;
                vein.add(ore);
                nextNext.addAll(this.getSurrounding(ore.getLocation()));
            }
            next = nextNext;
        }
        return vein;
    }
}

