/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.ArrayList;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.mining.Boring;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Quarry
extends Talent {
    private static String name = "Quarry";
    private static String description = "MINING MODE: Digging straight down mines 3x3. Increases to 5x5 with diamond and 7x7 with netherite. (Press the swap item button to change mining modes; default is F)";
    private static String tree = "Mining";
    private static int requiredLevel = 25;
    private static Material icon = Material.ANDESITE;
    private static int slot = 25;

    public Quarry() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Boring(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(BlockBreakEvent e, boolean isSecondary) {
        Block b = e.getBlock();
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        String face = PersistentDataUtility.readString((Entity)p, "mining_face", BlockFace.SELF.name());
        if (!face.equals("UP")) {
            return;
        }
        if (!Quarry.isStraightDown(b, p)) {
            return;
        }
        ArrayList<Block> phase1 = new ArrayList<Block>();
        ArrayList<Block> phase2 = new ArrayList<Block>();
        ArrayList<Block> phase3 = new ArrayList<Block>();
        ArrayList<Block> phase4 = new ArrayList<Block>();
        ArrayList<Block> phase5 = new ArrayList<Block>();
        ArrayList<Block> phase6 = new ArrayList<Block>();
        ArrayList<ArrayList<Block>> blocks = new ArrayList<ArrayList<Block>>();
        blocks.add(phase1);
        blocks.add(phase2);
        blocks.add(phase3);
        blocks.add(phase4);
        blocks.add(phase5);
        blocks.add(phase6);
        phase1.add(b.getRelative(BlockFace.NORTH));
        phase1.add(b.getRelative(BlockFace.SOUTH));
        phase1.add(b.getRelative(BlockFace.EAST));
        phase1.add(b.getRelative(BlockFace.WEST));
        phase2.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST));
        phase2.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST));
        phase2.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST));
        phase2.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST));
        if (Quarry.getPickPower(item) >= 3) {
            phase2.add(b.getRelative(BlockFace.NORTH, 2));
            phase2.add(b.getRelative(BlockFace.SOUTH, 2));
            phase2.add(b.getRelative(BlockFace.EAST, 2));
            phase2.add(b.getRelative(BlockFace.WEST, 2));
            phase3.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST));
            phase3.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST));
            phase3.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            phase3.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            phase3.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST));
            phase3.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST));
            phase3.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            phase3.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            phase4.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            phase4.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            phase4.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            phase4.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
        }
        if (Quarry.getPickPower(item) >= 4) {
            phase3.add(b.getRelative(BlockFace.NORTH, 3));
            phase3.add(b.getRelative(BlockFace.SOUTH, 3));
            phase3.add(b.getRelative(BlockFace.EAST, 3));
            phase3.add(b.getRelative(BlockFace.WEST, 3));
            phase4.add(b.getRelative(BlockFace.NORTH, 3).getRelative(BlockFace.EAST));
            phase4.add(b.getRelative(BlockFace.NORTH, 3).getRelative(BlockFace.WEST));
            phase4.add(b.getRelative(BlockFace.SOUTH, 3).getRelative(BlockFace.EAST));
            phase4.add(b.getRelative(BlockFace.SOUTH, 3).getRelative(BlockFace.WEST));
            phase4.add(b.getRelative(BlockFace.EAST, 3).getRelative(BlockFace.NORTH));
            phase4.add(b.getRelative(BlockFace.EAST, 3).getRelative(BlockFace.SOUTH));
            phase4.add(b.getRelative(BlockFace.WEST, 3).getRelative(BlockFace.NORTH));
            phase4.add(b.getRelative(BlockFace.WEST, 3).getRelative(BlockFace.SOUTH));
            phase5.add(b.getRelative(BlockFace.NORTH, 3).getRelative(BlockFace.EAST, 2));
            phase5.add(b.getRelative(BlockFace.NORTH, 3).getRelative(BlockFace.WEST, 2));
            phase5.add(b.getRelative(BlockFace.SOUTH, 2).getRelative(BlockFace.EAST, 3));
            phase5.add(b.getRelative(BlockFace.SOUTH, 2).getRelative(BlockFace.WEST, 3));
            phase5.add(b.getRelative(BlockFace.NORTH, 2).getRelative(BlockFace.EAST, 3));
            phase5.add(b.getRelative(BlockFace.NORTH, 2).getRelative(BlockFace.WEST, 3));
            phase5.add(b.getRelative(BlockFace.SOUTH, 3).getRelative(BlockFace.EAST, 2));
            phase5.add(b.getRelative(BlockFace.SOUTH, 3).getRelative(BlockFace.WEST, 2));
            phase6.add(b.getRelative(BlockFace.NORTH, 3).getRelative(BlockFace.EAST, 3));
            phase6.add(b.getRelative(BlockFace.NORTH, 3).getRelative(BlockFace.WEST, 3));
            phase6.add(b.getRelative(BlockFace.SOUTH, 3).getRelative(BlockFace.EAST, 3));
            phase6.add(b.getRelative(BlockFace.SOUTH, 3).getRelative(BlockFace.WEST, 3));
        }
        p.playSound(p.getLocation(), Sound.BLOCK_SHROOMLIGHT_PLACE, 1.0f, 0.5f);
        UltraBlock.breakBlocks(blocks, p);
    }

    public static boolean isStraightDown(Block block, Player player) {
        double playerX = player.getLocation().getBlockX();
        double blockX = block.getX();
        double playerZ = player.getLocation().getBlockZ();
        double blockZ = block.getZ();
        return Math.abs(playerX - blockX) + Math.abs(playerZ - blockZ) <= 1.5;
    }

    private static int getPickPower(ItemStack i) {
        Material m = i.getType();
        if (m == Material.WOODEN_PICKAXE) {
            return 1;
        }
        if (m == Material.STONE_PICKAXE) {
            return 1;
        }
        if (m == Material.IRON_PICKAXE) {
            return 2;
        }
        if (m == Material.GOLDEN_PICKAXE) {
            return 2;
        }
        if (m == Material.DIAMOND_PICKAXE) {
            return 3;
        }
        if (m == Material.NETHERITE_PICKAXE) {
            return 4;
        }
        return 0;
    }
}

