/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Momentum
extends Talent {
    private static String name = "Momentum";
    private static String description = "Gain stacking haste for continuous mining and digging";
    private static String tree = "Mining";
    private static int requiredLevel = 15;
    private static Material icon = Material.GOLDEN_BOOTS;
    private static int slot = 15;

    public Momentum() {
        super(name, description, tree, requiredLevel);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Momentum(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material m = block.getType();
        if (Momentum.hasAbility(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL) && (tool.getType().name().endsWith("_PICKAXE") || tool.getType().name().endsWith("_SHOVEL"))) {
            NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks");
            if (player.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
                player.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)(this.getStacks(player) + 1));
                if (this.getStacks(player) >= 40) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 80, 3));
                } else if (this.getStacks(player) >= 30) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 80, 2));
                } else if (this.getStacks(player) >= 20) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 80, 1));
                } else if (this.getStacks(player) >= 10) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 80, 0));
                }
                int current_stacks = this.getStacks(player);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UltraSkills.getPlugin(), () -> {
                    if (this.getStacks(player) == current_stacks) {
                        this.resetStacks(player);
                    }
                }, 200L);
            }
        }
    }

    int getStacks(Player p) {
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks");
        return (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
    }

    void resetStacks(Player p) {
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks");
        p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks");
        if (!p.getPersistentDataContainer().has(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks"), PersistentDataType.INTEGER)) {
            p.getPersistentDataContainer().set(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks"), PersistentDataType.INTEGER, (Object)0);
        }
        if ((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) != 0) {
            p.getPersistentDataContainer().set(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "momentum-stacks"), PersistentDataType.INTEGER, (Object)0);
        }
    }
}

