/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.EnumSet;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.tools.Pickaxe;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlockBreakEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Metallurgist
extends Talent {
    private static String name = "Metallurgist";
    private static String description = "Automatically smelt ore when you mine it.";
    private static String tree = "Mining";
    private static int requiredLevel = 34;
    private static Material icon = Material.IRON_INGOT;
    private static int slot = 34;
    public static final Set<Material> SMELTED_ORES = EnumSet.of(Material.COPPER_ORE, new Material[]{Material.IRON_ORE, Material.GOLD_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS});

    public Metallurgist() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Metallurgist(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player p = event.getPlayer();
        Block b = event.getBlock();
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (!Pickaxe.isPickaxe(tool)) {
            return;
        }
        if (!Metallurgist.hasAbility(p)) {
            return;
        }
        if (!SMELTED_ORES.contains(b.getType())) {
            return;
        }
    }

    @EventHandler
    public void onUltraBlockBreak(UltraBlockBreakEvent event) {
        Player p = event.getPlayer();
        Block b = event.getBlock();
        ItemStack tool = event.getTool();
        if (!Pickaxe.isPickaxe(tool)) {
            return;
        }
        if (!Metallurgist.hasAbility(p)) {
            return;
        }
        if (!SMELTED_ORES.contains(b.getType())) {
            return;
        }
    }

    @EventHandler
    public void onItemDrop(BlockDropItemEvent event) {
        Player p = event.getPlayer();
        Material blockType = event.getBlockState().getType();
        if (!Metallurgist.hasAbility(p)) {
            return;
        }
        if (!SMELTED_ORES.contains(blockType)) {
            return;
        }
        DebugUtility.consoleMessage(blockType + " drops:", 4);
        for (Item item : event.getItems()) {
            Material dropType = item.getItemStack().getType();
            Material smeltType = this.smeltDrops(item).getItemStack().getType();
            String message = "    -" + smeltType + " x" + item.getItemStack().getAmount();
            if (!smeltType.equals((Object)dropType)) {
                message = message + " (smelted from " + dropType + ")";
            }
            DebugUtility.consoleMessage(message, 4);
        }
    }

    public Item smeltDrops(Item item) {
        Material dropType = item.getItemStack().getType();
        Material ingotMaterial = null;
        switch (dropType) {
            case RAW_COPPER: {
                ingotMaterial = Material.COPPER_INGOT;
                break;
            }
            case RAW_IRON: {
                ingotMaterial = Material.IRON_INGOT;
                break;
            }
            case RAW_GOLD: {
                ingotMaterial = Material.GOLD_INGOT;
                break;
            }
            case ANCIENT_DEBRIS: {
                ingotMaterial = Material.NETHERITE_SCRAP;
                break;
            }
        }
        if (ingotMaterial != null) {
            item.getItemStack().setType(ingotMaterial);
        }
        return item;
    }
}

