/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Magnetic
extends Talent {
    private static String name = "Magnetic";
    private static String description = "Ores you mine get deposited directly into your inventory.";
    private static String tree = "Mining";
    private static int requiredLevel = 10;
    private static Material icon = Material.COMPASS;
    private static int slot = 10;
    public static final Set<Material> ORES = EnumSet.of(Material.COAL_ORE, new Material[]{Material.COPPER_ORE, Material.LAPIS_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.REDSTONE_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS});

    public Magnetic() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Magnetic(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockDropItemEvent event) {
        Player player = event.getPlayer();
        if (!Magnetic.hasAbility(player)) {
            return;
        }
        if (!ORES.contains(event.getBlockState().getType())) {
            return;
        }
        for (Item item : event.getItems()) {
            this.sendItemToPlayerInventory(player, item.getItemStack());
            item.remove();
        }
    }

    public void sendItemToPlayerInventory(Player player, ItemStack item) {
        PlayerInventory inventory = player.getInventory();
        HashMap remainingItems = inventory.addItem(new ItemStack[]{item});
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
        if (!remainingItems.isEmpty()) {
            for (ItemStack remainingItem : remainingItems.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), remainingItem);
            }
        }
    }
}

