/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.tools.Pickaxe;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.ubb.UltraBlockBreakEvent;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class IcePick
extends Talent {
    private static String name = "IcePick";
    private static String description = "When breaking blocks with a pickaxe, adjacent water and lava blocks get turned into compacted ice or magma, respectively.";
    private static String tree = "Mining";
    private static int requiredLevel = 40;
    private static Material icon = Material.PACKED_ICE;
    private static int slot = 40;

    public IcePick() {
        super(name, description, tree, requiredLevel);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new IcePick(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player p = event.getPlayer();
        if (!Pickaxe.isPickaxe(p.getInventory().getItemInMainHand())) {
            return;
        }
        if (!IcePick.hasAbility(p)) {
            return;
        }
        this.replaceNeighborBlocks(event.getBlock());
    }

    @EventHandler
    public void onUltraBlockBreak(UltraBlockBreakEvent event) {
        Player p = event.getPlayer();
        if (!Pickaxe.isPickaxe(event.getTool())) {
            return;
        }
        if (!IcePick.hasAbility(p)) {
            return;
        }
        this.replaceNeighborBlocks(event.getBlock());
    }

    public void replaceNeighborBlocks(Block block) {
        BlockFace[] neighbors;
        if (block.getType().equals((Object)Material.ICE)) {
            block.setType(Material.AIR);
        }
        for (BlockFace face : neighbors = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Block neighbor = block.getRelative(face);
            Material neighborType = neighbor.getType();
            if (neighborType.equals((Object)Material.LAVA)) {
                neighbor.setType(Material.MAGMA_BLOCK);
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 0.3f, 1.0f);
                continue;
            }
            if (!neighborType.equals((Object)Material.WATER)) continue;
            neighbor.setType(Material.ICE);
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_GLASS_PLACE, 0.3f, 1.0f);
        }
    }
}

