/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.tools.Pickaxe;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlockBreakEvent;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Gravedigger
extends Talent {
    private static String name = "Gravedigger";
    private static String description = "Digging builds up charge in your pickaxe/shovel. Striking something releases this energy to do more damage and increase knockback.";
    private static String tree = "Mining";
    private static int requiredLevel = 18;
    private static Material icon = Material.STONE_SHOVEL;
    private static int slot = 18;

    public Gravedigger() {
        super(name, description, tree, requiredLevel);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Gravedigger(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @EventHandler
    public void onEquipPickaxe(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        ItemStack item = e.getPlayer().getItemOnCursor();
        if (Pickaxe.isPickaxe(item)) {
            this.effects(p);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.addStack(event.getPlayer());
    }

    @EventHandler
    public void onUltraBlockBreak(UltraBlockBreakEvent event) {
        this.addStack(event.getPlayer());
    }

    @EventHandler
    public void onHitWithPickAxe(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!Pickaxe.isPickaxe(p.getInventory().getItemInMainHand())) {
            return;
        }
        if (this.getStacks(p) <= 0) {
            return;
        }
        int stacks = this.getStacks(p);
        if (stacks > 20) {
            stacks = 20;
        }
        e.setDamage(e.getDamage() + (double)stacks);
        DebugUtility.consoleMessage("Gravedigger damage increase: " + stacks, 4);
        p.playSound(p.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 0.8f);
        this.resetStacks(p);
    }

    private void addStack(Player p) {
        if (!Gravedigger.hasAbility(p)) {
            return;
        }
        ItemStack item = p.getInventory().getItemInMainHand();
        if (!Pickaxe.isPickaxe(item)) {
            return;
        }
        DebugUtility.consoleMessage("Gravedigger", 4);
        if (this.getStacks(p) < 20) {
            DebugUtility.consoleMessage("Gravedigger + 1", 4);
            PersistentDataUtility.store((Entity)p, name, this.getStacks(p) + 1);
            p.playSound(p.getLocation(), Sound.BLOCK_ROOTED_DIRT_BREAK, 1.0f, 0.5f + (float)this.getStacks(p) / 20.0f);
        }
        if (this.getStacks(p) == 1) {
            DebugUtility.consoleMessage("Gravedigger effects", 4);
            this.effects(p);
        }
    }

    private int getStacks(Player p) {
        return PersistentDataUtility.readInt((Entity)p, name, 0);
    }

    private void resetStacks(Player p) {
        PersistentDataUtility.store((Entity)p, name, 0);
    }

    private void effects(final Player p) {
        final ItemStack item = p.getInventory().getItemInMainHand();
        new BukkitRunnable(){

            public void run() {
                if (Gravedigger.this.getStacks(p) == 0 || !p.getInventory().getItemInMainHand().equals((Object)item)) {
                    this.cancel();
                } else {
                    for (int i = 0; i < Gravedigger.this.getStacks(p); ++i) {
                        p.spawnParticle(Particle.ELECTRIC_SPARK, p.getEyeLocation(), 1, Math.random(), Math.random(), Math.random());
                    }
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 40L);
    }
}

