/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class Geothermal
extends Talent {
    private static String name = "Geothermal";
    private static String description = "Regain hunger the lower y level you go (fixed value equivalent to y=-128 in nether; do not receive in the end)";
    private static String tree = "Mining";
    private static int requiredLevel = 38;
    private static Material icon = Material.LAVA_BUCKET;
    private static int slot = 38;

    public Geothermal() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Geothermal(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Geothermal.scheduler();
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                int y = p.getLocation().getBlockY();
                if (!Geothermal.hasAbility(p) || p.getWorld().getEnvironment() == World.Environment.THE_END) continue;
                if (p.getFoodLevel() < 20) {
                    int energy_amount = p.getWorld().getEnvironment() == World.Environment.NETHER || p.isInLava() ? 5 : (y < 64 && y >= 32 ? 1 : (y < 32 && y >= 0 ? 2 : (y < 0 && y >= -32 ? 3 : (y < -32 ? 4 : 0))));
                    if (energy_amount <= 0) continue;
                    p.setFoodLevel(p.getFoodLevel() + energy_amount);
                    continue;
                }
                if (p.getWorld().getEnvironment() != World.Environment.NETHER || !(p.getSaturation() < (float)p.getFoodLevel())) continue;
                p.setSaturation(p.getSaturation() + 2.0f);
                Geothermal.indicators(p);
                if (!(p.getSaturation() >= 20.0f)) continue;
                p.sendMessage("You have fully absorbed the mantle's energy.");
                p.playSound(p.getLocation(), Sound.BLOCK_LAVA_AMBIENT, 30.0f, 1.0f);
            }
        }, 0L, 80L);
    }

    public static void indicators(Player p) {
        for (int i = 0; i < 20; ++i) {
            p.spawnParticle(Particle.COMPOSTER, p.getEyeLocation(), 1, Math.random(), Math.random(), Math.random());
        }
        UltraSkills.getPlugin().getLogger().info(p.getName() + " gains energy from the sun. (4s)");
    }
}

