/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.EnumSet;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Fragments
extends Talent {
    private static String name = "Fragments";
    private static String description = "When mining stone, have a small chance to dig up valuables.";
    private static String tree = "Mining";
    private static int requiredLevel = 7;
    private static Material icon = Material.GOLD_NUGGET;
    private static int slot = 7;
    public static Set<Material> ores = EnumSet.of(Material.COAL_ORE, new Material[]{Material.COPPER_ORE, Material.LAPIS_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.REDSTONE_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE});

    public Fragments() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Fragments(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material m = block.getType();
        if (!Fragments.hasAbility(player) || !player.getGameMode().equals((Object)GameMode.SURVIVAL) || !tool.getType().name().endsWith("_PICKAXE") || ores.contains(m)) {
            // empty if block
        }
    }

    @EventHandler
    public void onItemDrop(BlockDropItemEvent event) {
        World world = event.getBlock().getWorld();
        Player player = event.getPlayer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material m = block.getType();
        Location location = event.getBlock().getLocation();
        if (Fragments.hasAbility(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL) && tool.getType().name().endsWith("_PICKAXE") && ores.contains(m)) {
            Item i = world.dropItem(location, new ItemStack(Material.GOLD_NUGGET));
            event.getItems().add(i);
        }
    }
}

