/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.EnumSet;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Excavator
extends Talent {
    private static String name = "Excavator";
    private static String description = "Break entire pockets of gravel, clay, tuff, andesite, granite, and diorite.";
    private static String tree = "Mining";
    private static int requiredLevel = 23;
    private static Material icon = Material.GOLDEN_SHOVEL;
    private static int slot = 23;
    public static final Set<Material> EXCAVATION_MATERIAL = EnumSet.of(Material.GRAVEL, new Material[]{Material.CLAY, Material.TUFF, Material.ANDESITE, Material.GRANITE, Material.DIORITE});
    private static final int max_affected_blocks = 1024;

    public Excavator() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Excavator(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player p = event.getPlayer();
        ItemStack tool = p.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material m = block.getType();
        if (!Excavator.hasAbility(p)) {
            return;
        }
        if (p.isSneaking()) {
            return;
        }
        if (!EXCAVATION_MATERIAL.contains(m)) {
            return;
        }
        UltraBlock.breakBlocks(UltraBlock.findContiguousBlocks(block, true, 1024), p);
    }
}

